/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public final class AllOfAggregationBuilder<T> {
    private final List<Tag> tags = new ArrayList<Tag>();
    private final List<AggregateOperation1> operations = new ArrayList<AggregateOperation1>();

    AllOfAggregationBuilder() {
    }

    @Nonnull
    public <R> Tag<R> add(@Nonnull AggregateOperation1<? super T, ?, R> operation) {
        this.operations.add(operation);
        Tag tag = Tag.tag(this.tags.size());
        this.tags.add(tag);
        return tag;
    }

    @Nonnull
    public AggregateOperation1<T, Object[], ItemsByTag> build() {
        return this.build(FunctionEx.identity());
    }

    @Nonnull
    public <R> AggregateOperation1<T, Object[], R> build(@Nonnull FunctionEx<ItemsByTag, R> exportFinishFn) {
        SerializationUtil.checkSerializable(exportFinishFn, "exportFinishFn");
        List<Tag> tags = this.tags;
        List<AggregateOperation1> operations = this.operations;
        return AggregateOperation.withCreate(() -> {
            Object[] acc = new Object[tags.size()];
            Arrays.setAll(acc, i2 -> ((AggregateOperation1)operations.get(i2)).createFn().get());
            return acc;
        }).andAccumulate((acc, item) -> {
            for (int i2 = 0; i2 < ((Object[])acc).length; ++i2) {
                ((AggregateOperation1)operations.get(i2)).accumulateFn().accept(acc[i2], item);
            }
        }).andCombine(operations.stream().anyMatch(o -> o.combineFn() == null) ? null : (acc1, acc2) -> {
            for (int i2 = 0; i2 < ((Object[])acc1).length; ++i2) {
                ((AggregateOperation1)operations.get(i2)).combineFn().accept(acc1[i2], acc2[i2]);
            }
        }).andDeduct(operations.stream().anyMatch(o -> o.deductFn() == null) ? null : (acc1, acc2) -> {
            for (int i2 = 0; i2 < ((Object[])acc1).length; ++i2) {
                ((AggregateOperation1)operations.get(i2)).deductFn().accept(acc1[i2], acc2[i2]);
            }
        }).andExport(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i2 = 0; i2 < tags.size(); ++i2) {
                Object exportedVal = ((AggregateOperation1)operations.get(i2)).exportFn().apply(acc[i2]);
                result.put((Tag)tags.get(i2), exportedVal);
            }
            return exportFinishFn.apply(result);
        }).andFinish(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i2 = 0; i2 < tags.size(); ++i2) {
                Object finishedVal = ((AggregateOperation1)operations.get(i2)).finishFn().apply(acc[i2]);
                result.put((Tag)tags.get(i2), finishedVal);
            }
            return exportFinishFn.apply(result);
        });
    }
}

