/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperationBuilder;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class CoAggregateOperationBuilder {
    private final Map<Tag, AggregateOperation1> opsByTag = new HashMap<Tag, AggregateOperation1>();

    CoAggregateOperationBuilder() {
    }

    @Nonnull
    public <T, R> Tag<R> add(@Nonnull Tag<T> tag, @Nonnull AggregateOperation1<? super T, ?, ? extends R> operation) {
        this.opsByTag.put(tag, operation);
        return tag;
    }

    @Nonnull
    public AggregateOperation<Object[], ItemsByTag> build() {
        return this.build(FunctionEx.identity());
    }

    @Nonnull
    public <R> AggregateOperation<Object[], R> build(@Nonnull FunctionEx<? super ItemsByTag, ? extends R> exportFinishFn) {
        SerializationUtil.checkSerializable(exportFinishFn, "exportFinishFn");
        Tag[] tags = (Tag[])this.opsByTag.keySet().stream().sorted().toArray(Tag[]::new);
        for (int i2 = 0; i2 < tags.length; ++i2) {
            Preconditions.checkTrue(tags[i2].index() == i2, "Registered tags' indices are " + Arrays.stream(tags).map(Tag::index).collect(Collectors.toList()) + ", but should be " + IntStream.range(0, tags.length).boxed().collect(Collectors.toList()));
        }
        Stream sorted = this.opsByTag.entrySet().stream().sorted(Map.Entry.comparingByKey());
        List ops = sorted.map(Map.Entry::getValue).collect(Collectors.toList());
        BiConsumerEx[] combineFns = (BiConsumerEx[])ops.stream().map(AggregateOperation::combineFn).toArray(BiConsumerEx[]::new);
        BiConsumerEx[] deductFns = (BiConsumerEx[])ops.stream().map(AggregateOperation::deductFn).toArray(BiConsumerEx[]::new);
        FunctionEx[] exportFns = (FunctionEx[])ops.stream().map(AggregateOperation::exportFn).toArray(FunctionEx[]::new);
        FunctionEx[] finishFns = (FunctionEx[])ops.stream().map(AggregateOperation::finishFn).toArray(FunctionEx[]::new);
        AggregateOperationBuilder.VarArity<Object[], Void> b = AggregateOperation.withCreate(() -> ops.stream().map(op -> op.createFn().get()).toArray()).varArity();
        this.opsByTag.forEach((tag, op) -> {
            int index = tag.index();
            b.andAccumulate(tag, (acc, item) -> op.accumulateFn().accept(acc[index], item));
        });
        return b.andCombine(Arrays.stream(combineFns).anyMatch(Objects::isNull) ? null : (acc1, acc2) -> {
            for (int i2 = 0; i2 < combineFns.length; ++i2) {
                combineFns[i2].accept(acc1[i2], acc2[i2]);
            }
        }).andDeduct(Arrays.stream(deductFns).anyMatch(Objects::isNull) ? null : (acc1, acc2) -> {
            for (int i2 = 0; i2 < deductFns.length; ++i2) {
                deductFns[i2].accept(acc1[i2], acc2[i2]);
            }
        }).andExport(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i2 = 0; i2 < exportFns.length; ++i2) {
                result.put(tags[i2], exportFns[i2].apply(acc[i2]));
            }
            return exportFinishFn.apply(result);
        }).andFinish(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i2 = 0; i2 < finishFns.length; ++i2) {
                result.put(tags[i2], finishFns[i2].apply(acc[i2]));
            }
            return exportFinishFn.apply(result);
        });
    }
}

