/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.core.metrics.Measurement;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public final class JobMetricsUtil {
    private JobMetricsUtil() {
    }

    public static Long getExecutionIdFromMetricsDescriptor(MetricDescriptor descriptor) {
        for (int i2 = 0; i2 < descriptor.tagCount(); ++i2) {
            if (!"exec".equals(descriptor.tag(i2))) continue;
            return Util.idFromString(descriptor.tagValue(i2));
        }
        return null;
    }

    public static UnaryOperator<MetricDescriptor> addMemberPrefixFn(@Nonnull Member member) {
        String uuid = member.getUuid().toString();
        String addr = member.getAddress().toString();
        return d -> d.copy().withTag("member", uuid).withTag("address", addr);
    }

    static JobMetrics toJobMetrics(List<RawJobMetrics> rawJobMetrics) {
        JobMetricsConsumer consumer = null;
        for (RawJobMetrics metrics : rawJobMetrics) {
            if (metrics.getBlob() == null) continue;
            if (consumer == null) {
                consumer = new JobMetricsConsumer();
            }
            consumer.timestamp = metrics.getTimestamp();
            MetricsCompressor.extractMetrics(metrics.getBlob(), consumer);
        }
        return consumer == null ? JobMetrics.empty() : JobMetrics.of(consumer.metrics);
    }

    private static class JobMetricsConsumer
    implements MetricConsumer {
        final Map<String, List<Measurement>> metrics = new HashMap<String, List<Measurement>>();
        long timestamp;

        private JobMetricsConsumer() {
        }

        @Override
        public void consumeLong(MetricDescriptor descriptor, long value) {
            this.metrics.computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        @Override
        public void consumeDouble(MetricDescriptor descriptor, double value) {
            this.consumeLong(descriptor, (long)value);
        }

        private Measurement measurement(MetricDescriptor descriptor, long value) {
            Map<String, String> tags = MapUtil.createHashMap(descriptor.tagCount());
            for (int i2 = 0; i2 < descriptor.tagCount(); ++i2) {
                tags.put(descriptor.tag(i2), descriptor.tagValue(i2));
            }
            if (descriptor.discriminator() != null || descriptor.discriminatorValue() != null) {
                tags.put(descriptor.discriminator(), descriptor.discriminatorValue());
            }
            return Measurement.of(descriptor.metric(), value, this.timestamp, tags);
        }
    }
}

