/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Watermark;
import java.util.Arrays;

public abstract class WatermarkCoalescer {
    public static final long IDLE_MESSAGE_TIME = Long.MAX_VALUE;
    public static final Watermark IDLE_MESSAGE = new Watermark(Long.MAX_VALUE, 0);
    static final long NO_NEW_WM = Long.MIN_VALUE;

    private WatermarkCoalescer() {
    }

    public abstract long queueDone(int var1);

    public abstract void observeEvent(int var1);

    public abstract long observeWm(int var1, long var2);

    public abstract boolean idleMessagePending();

    public abstract long coalescedWm();

    public abstract long topObservedWm();

    public static WatermarkCoalescer create(int queueCount) {
        Preconditions.checkNotNegative(queueCount, "queueCount must be >= 0, but is " + queueCount);
        switch (queueCount) {
            case 0: {
                return new ZeroInputImpl();
            }
            case 1: {
                return new SingleInputImpl();
            }
        }
        return new StandardImpl(queueCount);
    }

    private static final class ZeroInputImpl
    extends WatermarkCoalescer {
        private ZeroInputImpl() {
        }

        @Override
        public void observeEvent(int queueIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long observeWm(int queueIndex, long wmValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long queueDone(int queueIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean idleMessagePending() {
            return false;
        }

        @Override
        public long coalescedWm() {
            return Long.MIN_VALUE;
        }

        @Override
        public long topObservedWm() {
            return Long.MIN_VALUE;
        }
    }

    private static final class SingleInputImpl
    extends WatermarkCoalescer {
        private final Counter queueWm = SwCounter.newSwCounter(Long.MIN_VALUE);
        private boolean idleMessagePending;

        private SingleInputImpl() {
        }

        @Override
        public long queueDone(int queueIndex) {
            assert (this.queueWm.get() < Long.MAX_VALUE) : "Duplicate DONE call";
            this.queueWm.set(Long.MAX_VALUE);
            return Long.MIN_VALUE;
        }

        @Override
        public void observeEvent(int queueIndex) {
        }

        @Override
        public long observeWm(int queueIndex, long wmValue) {
            assert (queueIndex == 0) : "queueIndex=" + queueIndex;
            if (this.queueWm.get() >= wmValue) {
                throw new JetException("Watermarks not monotonically increasing on queue: last one=" + this.queueWm + ", new one=" + wmValue);
            }
            if (wmValue == Long.MAX_VALUE) {
                this.idleMessagePending = true;
                return Long.MIN_VALUE;
            }
            this.queueWm.set(wmValue);
            return wmValue;
        }

        @Override
        public boolean idleMessagePending() {
            try {
                boolean bl = this.idleMessagePending;
                return bl;
            }
            finally {
                this.idleMessagePending = false;
            }
        }

        @Override
        public long coalescedWm() {
            return this.queueWm.get();
        }

        @Override
        public long topObservedWm() {
            return this.queueWm.get();
        }
    }

    private static final class StandardImpl
    extends WatermarkCoalescer {
        private final long[] queueWms;
        private final boolean[] isIdle;
        private final Counter lastEmittedWm = SwCounter.newSwCounter(Long.MIN_VALUE);
        private final Counter topObservedWm = SwCounter.newSwCounter(Long.MIN_VALUE);
        private boolean allInputsAreIdle;
        private boolean idleMessagePending;

        StandardImpl(int queueCount) {
            this.isIdle = new boolean[queueCount];
            this.queueWms = new long[queueCount];
            Arrays.fill(this.queueWms, Long.MIN_VALUE);
        }

        @Override
        public long queueDone(int queueIndex) {
            assert (this.queueWms[queueIndex] < Long.MAX_VALUE) : "Duplicate DONE call";
            this.queueWms[queueIndex] = Long.MAX_VALUE;
            return this.checkObservedWms();
        }

        @Override
        public void observeEvent(int queueIndex) {
            if (this.isIdle[queueIndex]) {
                this.isIdle[queueIndex] = false;
                this.allInputsAreIdle = false;
            }
        }

        @Override
        public long observeWm(int queueIndex, long wmValue) {
            if (this.queueWms[queueIndex] >= wmValue) {
                throw new JetException("Watermarks not monotonically increasing on queue: last one=" + this.queueWms[queueIndex] + ", new one=" + wmValue);
            }
            if (wmValue == Long.MAX_VALUE) {
                this.isIdle[queueIndex] = true;
            } else {
                this.isIdle[queueIndex] = false;
                this.allInputsAreIdle = false;
                this.queueWms[queueIndex] = wmValue;
                if (wmValue > this.topObservedWm.get()) {
                    this.topObservedWm.set(wmValue);
                }
            }
            return this.checkObservedWms();
        }

        private long checkObservedWms() {
            if (this.allInputsAreIdle) {
                return Long.MIN_VALUE;
            }
            long min = Long.MAX_VALUE;
            int notDoneInputCount = 0;
            for (int i2 = 0; i2 < this.queueWms.length; ++i2) {
                if (this.queueWms[i2] < Long.MAX_VALUE) {
                    ++notDoneInputCount;
                }
                if (this.isIdle[i2] || this.queueWms[i2] >= min) continue;
                min = this.queueWms[i2];
            }
            if (min == Long.MAX_VALUE) {
                this.allInputsAreIdle = true;
                this.idleMessagePending = notDoneInputCount != 0;
                long topObservedWmLocal = this.topObservedWm.get();
                if (topObservedWmLocal > this.lastEmittedWm.get()) {
                    this.lastEmittedWm.set(topObservedWmLocal);
                    return topObservedWmLocal;
                }
                return Long.MIN_VALUE;
            }
            if (min > this.lastEmittedWm.get()) {
                this.lastEmittedWm.set(min);
                return min;
            }
            return Long.MIN_VALUE;
        }

        @Override
        public boolean idleMessagePending() {
            try {
                boolean bl = this.idleMessagePending;
                return bl;
            }
            finally {
                this.idleMessagePending = false;
            }
        }

        @Override
        public long coalescedWm() {
            return this.lastEmittedWm.get();
        }

        @Override
        public long topObservedWm() {
            return this.topObservedWm.get();
        }
    }
}

