/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

class CompositeMutationObserver<R extends Record>
implements MutationObserver<R> {
    private static final int DEFAULT_OBSERVER_COUNT = 4;
    private List<MutationObserver> mutationObservers = Collections.EMPTY_LIST;

    CompositeMutationObserver() {
    }

    public void add(MutationObserver<R> mutationObserver) {
        if (this.mutationObservers == Collections.EMPTY_LIST) {
            this.mutationObservers = new ArrayList<MutationObserver>(4);
        }
        this.mutationObservers.add(mutationObserver);
    }

    @Override
    public void onClear() {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onClear();
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onPutRecord(Data key, R record, Object oldValue, boolean backup) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onPutRecord(key, record, oldValue, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull R record, boolean populateIndex) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onReplicationPutRecord(key, record, populateIndex);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onUpdateRecord(key, record, oldValue, newValue, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onRemoveRecord(Data key, R record, boolean backup) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onRemoveRecord(key, record, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onEvictRecord(Data key, R record, boolean backup) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onEvictRecord(key, record, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onLoadRecord(key, record, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onDestroy(isDuringShutdown, internal);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onReset() {
        Throwable throwable = null;
        for (int i2 = 0; i2 < this.mutationObservers.size(); ++i2) {
            try {
                this.mutationObservers.get(i2).onReset();
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }
}

