/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.multimap.impl.MultiMapDataSerializerHook;
import com.hazelcast.multimap.impl.operations.PutAllOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;

public class MultiMapPutAllOperationFactory
extends PartitionAwareOperationFactory {
    protected String name;
    protected MapEntries[] mapEntries;

    public MultiMapPutAllOperationFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MultiMapPutAllOperationFactory(String name, int[] partitions, MapEntries[] mapEntries) {
        this.name = name;
        this.partitions = partitions;
        this.mapEntries = mapEntries;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i2 = 0; i2 < this.partitions.length; ++i2) {
            if (this.partitions[i2] != partitionId) continue;
            return new PutAllOperation(this.name, this.mapEntries[i2]);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeIntArray(this.partitions);
        for (MapEntries entry : this.mapEntries) {
            entry.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitions = in.readIntArray();
        this.mapEntries = new MapEntries[this.partitions.length];
        for (int i2 = 0; i2 < this.partitions.length; ++i2) {
            MapEntries entry = new MapEntries();
            entry.readData(in);
            this.mapEntries[i2] = entry;
        }
    }

    @Override
    public int getFactoryId() {
        return MultiMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 55;
    }
}

