/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.projection.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.projection.impl.ProjectionDataSerializerHook;
import com.hazelcast.query.impl.Extractable;
import java.io.IOException;
import java.util.Arrays;

public final class MultiAttributeProjection<I>
implements Projection<I, Object[]>,
IdentifiedDataSerializable {
    private String[] attributePaths;

    MultiAttributeProjection() {
    }

    public MultiAttributeProjection(String ... attributePath) {
        if (attributePath == null || attributePath.length == 0) {
            throw new IllegalArgumentException("You need to specify at least one attributePath");
        }
        for (String path : attributePath) {
            Preconditions.checkHasText(path, "attributePath must not be null or empty");
            Preconditions.checkFalse(path.contains("[any]"), "attributePath must not contain [any] operators");
        }
        this.attributePaths = attributePath;
    }

    @Override
    public Object[] transform(I input) {
        if (input instanceof Extractable) {
            Extractable extractable = (Extractable)input;
            Object[] result = new Object[this.attributePaths.length];
            for (int i2 = 0; i2 < this.attributePaths.length; ++i2) {
                result[i2] = extractable.getAttributeValue(this.attributePaths[i2]);
            }
            return result;
        }
        throw new IllegalArgumentException("The given map entry is not extractable");
    }

    @Override
    public int getFactoryId() {
        return ProjectionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeStringArray(this.attributePaths);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributePaths = in.readStringArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiAttributeProjection that = (MultiAttributeProjection)o;
        return Arrays.equals(this.attributePaths, that.attributePaths);
    }

    public int hashCode() {
        return Arrays.hashCode(this.attributePaths);
    }
}

