/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.DummyTrustManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySSLSocketFactory
extends SSLSocketFactory {
    protected static final Logger log = LoggerFactory.getLogger(DummySSLSocketFactory.class);
    private final SSLSocketFactory factory;

    public DummySSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new DummyTrustManager()}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception ex) {
            log.error("Can not create and initialize SSL", ex);
            throw new IllegalStateException("Can not create and initialize SSL", ex);
        }
    }

    public static SocketFactory getDefault() {
        return new DummySSLSocketFactory();
    }

    private Socket addAnonCipher(Socket socket) {
        SSLSocket ssl = (SSLSocket)socket;
        ssl.setEnabledCipherSuites(DummySSLServerSocketFactory.addAnonCiphers(ssl.getEnabledCipherSuites()));
        return ssl;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.factory.createSocket();
        DummySSLSocketFactory.trySetFakeRemoteHost(socket);
        return this.addAnonCipher(socket);
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i2, boolean flag) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(socket, s, i2, flag));
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i2, InetAddress inaddr1, int j) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(inaddr, i2, inaddr1, j));
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i2) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(inaddr, i2));
    }

    @Override
    public Socket createSocket(String s, int i2, InetAddress inaddr, int j) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(s, i2, inaddr, j));
    }

    @Override
    public Socket createSocket(String s, int i2) throws IOException {
        return this.addAnonCipher(this.factory.createSocket(s, i2));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    private static void trySetFakeRemoteHost(Socket socket) {
        try {
            Method setHostMethod = socket.getClass().getMethod("setHost", String.class);
            String fakeHostName = "greenmailHost" + new BigInteger(130, new Random()).toString(32);
            setHostMethod.invoke((Object)socket, fakeHostName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.debug("Could not set fake remote host. SSL connection setup may be slow.");
        }
    }
}

