/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.AsymmetricKeyCache;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import net.messagevortex.asn1.encryption.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="keycache", aliases={"kc", "cache"}, description={"Handle the asymmetric key cache"}, mixinStandardHelpOptions=true)
public class AsymmetricKeyPreCalculator
implements Serializable,
Callable<Integer> {
    public static final String DEFAULT_CACHE_FILENAME = "AsymmetricKey.cache";
    public static final long serialVersionUID = 100000000031L;
    private static final String TMP_PREFIX = "Precalc";
    private static final Logger LOGGER;
    private static final boolean DISABLE_CACHE = false;
    @CommandLine.Option(names={"--stopIfFull"}, description={"stop the cache calculation if the cache is full"})
    private static boolean stopIfFull;
    private static final AsymmetricKeyCache cache;
    private static double dequeueProbability;
    private static File tempdir;
    private static long lastSaved;
    private static boolean firstWarning;
    private static volatile InternalThread runner;
    @CommandLine.Option(names={"--cacheFileName"}, description={"filename of the cache file"})
    private static String filename;
    private static int incrementor;
    private static int numThreads;
    private static final ThreadPoolExecutor pool;
    @CommandLine.Option(names={"--element"}, description={"the affected element"})
    private int elementIndex = -1;
    @CommandLine.Option(names={"--value"}, description={"number of elements for a key (requires --element)"})
    private int value = -1;

    private AsymmetricKeyPreCalculator() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsymmetricKeyPreCalculator(boolean detached) {
        File t = null;
        if (detached) {
            try {
                t = File.createTempFile("MessageVortexPrecalc", ".keydir");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Unable to create temp file", ioe);
            }
            finally {
                tempdir = t;
            }
            try {
                if (tempdir == null) {
                    throw new IOException("failed to create temp file");
                }
                if (!tempdir.delete()) {
                    throw new IOException("Could not delete temp file: " + tempdir.getAbsolutePath());
                }
                if (!tempdir.mkdir()) {
                    throw new IOException("Could not create temp directory: " + tempdir.getAbsolutePath());
                }
                tempdir.deleteOnExit();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Unable to create temp dir", ioe);
            }
        } else {
            tempdir = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsymmetricKey getPrecomputedAsymmetricKey(AlgorithmParameter parameters) {
        AlgorithmParameter ap = AsymmetricKeyPreCalculator.prepareParameters(parameters);
        AsymmetricKeyCache asymmetricKeyCache = cache;
        synchronized (asymmetricKeyCache) {
            if (filename == null && runner != null && !runner.isAlive()) {
                runner = null;
            }
            AsymmetricKeyCache asymmetricKeyCache2 = cache;
            synchronized (asymmetricKeyCache2) {
                if (filename == null) {
                    LOGGER.log(Level.INFO, "cache disabled .. no key offered");
                    return null;
                }
                if (cache.peek(ap) == null) {
                    cache.requestCacheIncrease(ap);
                    LOGGER.log(Level.FINE, "added new key type to cache (" + String.valueOf(ap) + ")");
                    return null;
                }
            }
            LOGGER.log(Level.FINE, "cache offered precalculated key");
            if (Math.random() < dequeueProbability) {
                return cache.pull(ap);
            }
            return cache.peek(ap);
        }
    }

    static double getDequeueProbability() {
        return dequeueProbability;
    }

    static double setDequeueProbability(double newProbability) {
        if (newProbability > 1.0 || newProbability < 0.0) {
            throw new IllegalArgumentException("probablitiy must be in interval [0,1]");
        }
        double ret = AsymmetricKeyPreCalculator.getDequeueProbability();
        dequeueProbability = newProbability;
        return ret;
    }

    public static int setNumThreads(int newNumThreads) {
        int old = AsymmetricKeyPreCalculator.getNumThreads();
        numThreads = newNumThreads;
        pool.setMaximumPoolSize(numThreads);
        return old;
    }

    public static int getNumThreads() {
        return numThreads;
    }

    private static AlgorithmParameter prepareParameters(AlgorithmParameter ap) {
        AlgorithmParameter ret = new AlgorithmParameter(ap);
        ret.put(Parameter.IV, null);
        ret.put(Parameter.PADDING, Padding.getDefault(AlgorithmType.ASYMMETRIC).toString());
        ret.put(Parameter.MODE, Mode.getDefault(AlgorithmType.ASYMMETRIC).toString());
        return ret;
    }

    public static String getCacheFileName() {
        return filename;
    }

    public static String setCacheFileName(String name) {
        if ("".equals(filename)) {
            filename = DEFAULT_CACHE_FILENAME;
        }
        if (filename != null && filename.equals(name)) {
            return filename;
        }
        if (filename == null && runner != null && !runner.isAlive()) {
            runner = null;
        }
        if (filename == null && name != null && runner != null) {
            throw new IllegalThreadStateException("Thread is still shutting down... try again later");
        }
        String ret = filename;
        filename = name;
        AsymmetricKeyPreCalculator.startOrStopThread();
        return ret;
    }

    @CommandLine.Command(name="run", description={"pre-populates the cache"})
    public static void fillCache() {
        try {
            if (filename == null || "".equals(filename)) {
                filename = DEFAULT_CACHE_FILENAME;
            }
            AsymmetricKeyPreCalculator.setCacheFileName(filename);
            stopIfFull = true;
            AsymmetricKeyPreCalculator.startOrStopThread();
            runner.join();
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.WARNING, "Got unexpected exception", ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startOrStopThread() {
        AsymmetricKeyCache asymmetricKeyCache = cache;
        synchronized (asymmetricKeyCache) {
            if (filename == null && runner != null) {
                runner.shutdown();
            }
            if (runner != null && !runner.isAlive()) {
                runner = null;
            }
            if (filename != null && runner == null) {
                try {
                    if (cache.isEmpty()) {
                        AsymmetricKeyPreCalculator.load(filename, false);
                    }
                }
                catch (IOException | ExceptionInInitializerError e) {
                    LOGGER.log(Level.FINE, "error loading cache file (will be recreated)", e);
                }
                runner = new InternalThread(stopIfFull);
            }
        }
    }

    private static void load(String inFile, boolean merge) throws IOException {
        LOGGER.log(Level.INFO, "loading cache from " + inFile);
        if (!merge) {
            cache.load(inFile);
        } else {
            cache.merge(inFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save() throws IOException {
        block15: {
            Object object;
            if (runner != null) {
                object = runner;
                synchronized (object) {
                    if (lastSaved + 60000L > System.currentTimeMillis()) {
                        return;
                    }
                }
            }
            if (filename != null) {
                if ("".equals(filename)) {
                    filename = DEFAULT_CACHE_FILENAME;
                }
                try {
                    object = cache;
                    synchronized (object) {
                        cache.store(filename + ".tmp");
                        lastSaved = System.currentTimeMillis();
                        if (tempdir != null && cache.getCacheFillGrade() >= 0.999) {
                            String fn = File.createTempFile("MessageVortexPrecalc", ".key").getAbsolutePath();
                            LOGGER.log(Level.INFO, "stored chunk to file \"" + fn + "\" to pick up");
                            Files.move(Paths.get(filename + ".tmp", new String[0]), Paths.get(fn, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            cache.clear();
                            if (stopIfFull) {
                                AsymmetricKeyPreCalculator.setCacheFileName(null);
                            }
                        } else {
                            LOGGER.log(Level.INFO, "stored cache to " + Paths.get(filename, new String[0]).getFileName().toString());
                            Files.move(Paths.get(filename + ".tmp", new String[0]), Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block15;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception while storing file", e);
                    throw e;
                }
            }
            LOGGER.log(Level.WARNING, "Cache not saved to disk (no filename for caching set)");
        }
    }

    @Override
    public Integer call() throws IOException {
        new AsymmetricKeyPreCalculator(true);
        if (cache.isEmpty()) {
            try {
                if (filename == null) {
                    filename = DEFAULT_CACHE_FILENAME;
                }
                AsymmetricKeyPreCalculator.load(filename, true);
            }
            catch (IOException ioe) {
                throw new IOException("unable to load existing asymmetric key cache file... aborting execution", ioe);
            }
            cache.clear();
            cache.showStats();
        }
        if (this.value == -1) {
            AsymmetricKeyPreCalculator.setCacheFileName(tempdir.getAbsolutePath() + "/precalcCache.cache");
        }
        try {
            runner.join();
        }
        catch (InterruptedException ie) {
            throw new IOException("Exception while waiting for cache runner to finish", ie);
        }
        return 0;
    }

    @CommandLine.Command(name="set", description={"sets the size of a specific cache element"})
    public void setCacheSize() throws IOException {
        LOGGER.log(Level.INFO, "SET called for element " + this.elementIndex);
        if (this.elementIndex <= 0 || this.value <= 0) {
            LOGGER.log(Level.SEVERE, "SET requires a valid element (" + this.elementIndex + ") and an valid value to be set (" + this.value + ")");
            System.exit(103);
        } else {
            this.setCacheSize(this.elementIndex, this.value);
        }
        AsymmetricKeyPreCalculator.setCacheFileName(null);
        System.exit(0);
    }

    public void setCacheSize(int index, int size) throws IOException {
        LOGGER.log(Level.INFO, "SET called for element " + index + " and size " + size);
        if (cache.isEmpty()) {
            try {
                LOGGER.log(Level.INFO, "loading cache " + filename);
                AsymmetricKeyPreCalculator.load(filename, true);
            }
            catch (IOException ioe) {
                throw new IOException("unable to load existing asymmetric key cache file... aborting execution", ioe);
            }
        }
        LOGGER.log(Level.INFO, "chaning cache size");
        cache.setCacheSize(this.elementIndex, this.value);
        cache.showStats();
        LOGGER.log(Level.INFO, "storing cache " + filename);
        cache.store(filename);
    }

    @CommandLine.Command(name="remove", description={"removes a specific cache element"})
    public void removeCacheElement() throws IOException {
        LOGGER.log(Level.INFO, "removing element " + this.elementIndex);
        if (this.elementIndex <= 0) {
            LOGGER.log(Level.SEVERE, "REMOVE requires a valid element (" + this.elementIndex + ")");
            System.exit(103);
        } else {
            this.removeCacheElement(this.elementIndex);
        }
        AsymmetricKeyPreCalculator.setCacheFileName(null);
        System.exit(0);
    }

    public void removeCacheElement(int index) throws IOException {
        if (cache.isEmpty()) {
            try {
                LOGGER.log(Level.INFO, "loading cache " + filename);
                AsymmetricKeyPreCalculator.load(filename, true);
            }
            catch (IOException ioe) {
                throw new IOException("unable to load existing asymmetric key cache file... aborting execution", ioe);
            }
        }
        LOGGER.log(Level.INFO, "removing element");
        cache.removeCacheElement(this.elementIndex);
        cache.showStats();
        LOGGER.log(Level.INFO, "storing cache " + filename);
        cache.store(filename);
    }

    @CommandLine.Command(name="list", description={"Lists all elements of the cache"})
    public void listCache() throws IOException {
        if (cache.isEmpty()) {
            try {
                LOGGER.log(Level.INFO, "loading cache " + filename);
                AsymmetricKeyPreCalculator.load(filename, true);
            }
            catch (IOException ioe) {
                throw new IOException("unable to load existing asymmetric key cache file... aborting execution", ioe);
            }
        }
        cache.showStats();
        AsymmetricKeyPreCalculator.setCacheFileName(null);
        System.exit(0);
    }

    static {
        stopIfFull = false;
        cache = new AsymmetricKeyCache();
        dequeueProbability = 1.0;
        tempdir = null;
        lastSaved = 0L;
        firstWarning = true;
        runner = null;
        filename = null;
        incrementor = 128;
        numThreads = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){

            @Override
            public boolean offer(Runnable e) {
                return this.tryTransfer(e);
            }
        };
        ThreadFactory factory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Precalc worker");
                t.setDaemon(true);
                return t;
            }
        };
        pool = new ThreadPoolExecutor(1, numThreads, 1L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, factory);
        pool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    lastSaved = -1L;
                    LOGGER.log(Level.INFO, "Storing cache state");
                    AsymmetricKeyPreCalculator.save();
                    InternalThread it = runner;
                    if (it != null) {
                        LOGGER.log(Level.INFO, "Shutdown cache runner");
                        it.shutdown();
                    }
                    LOGGER.log(Level.INFO, "Shutdown hook complete");
                }
                catch (IOException | RuntimeException ioe) {
                    LOGGER.log(Level.WARNING, "Error while writing cache", ioe);
                }
            }
        });
    }

    private static class InternalThread
    extends Thread {
        private static int counter = 0;
        private volatile boolean shutdown = false;
        private final boolean stopIfFull;

        InternalThread(boolean stopIfFull) {
            this.stopIfFull = stopIfFull;
            this.setDaemon(true);
            this.setPriority(1);
            this.setName("Precalc manager " + counter++);
            this.start();
            LOGGER.log(Level.INFO, "cache manager \"" + this.getName() + "\" started");
        }

        void shutdown() {
            pool.shutdown();
            try {
                pool.awaitTermination(3L, TimeUnit.SECONDS);
                pool.shutdownNow();
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.shutdown = true;
        }

        @Override
        public void run() {
            pool.allowCoreThreadTimeOut(true);
            while (!this.shutdown) {
                AlgorithmParameter p = cache.getSpeculativeParameter();
                if (p != null) {
                    this.calculateKey(p);
                    if (tempdir == null && this.mergePrecalculatedKeys()) {
                        try {
                            AsymmetricKeyPreCalculator.save();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Error saving cache (1)", e);
                        }
                        continue;
                    }
                    if (tempdir == null) continue;
                    try {
                        AsymmetricKeyPreCalculator.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Error saving cache (2)", e);
                    }
                    continue;
                }
                if (!this.stopIfFull) {
                    try {
                        LOGGER.log(Level.INFO, "cache is idle (" + String.format("%2.3f", cache.getCacheFillGrade() * 100.0) + "%) ... sleeping for a short while and waiting for requests");
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (!(cache.getCacheFillGrade() >= 0.999)) continue;
                LOGGER.log(Level.INFO, "cache is full(" + String.format("%2.3f", cache.getCacheFillGrade() * 100.0) + "%) ... shutting down");
                this.shutdown = true;
            }
        }

        private boolean mergePrecalculatedKeys() {
            boolean ret = false;
            ArrayList<File> listOfFiles = new ArrayList<File>();
            File[] fl = new File(System.getProperty("java.io.tmpdir")).listFiles();
            for (File tfile : fl == null ? new File[]{} : fl) {
                String targetFile;
                if (!tfile.isFile() || !(targetFile = tfile.getName()).startsWith("MessageVortexPrecalc") || !targetFile.endsWith(".key")) continue;
                listOfFiles.add(tfile);
            }
            for (File f : listOfFiles) {
                try {
                    double lowest = cache.getLowestCacheSize();
                    if (!(lowest < 0.4)) {
                        return ret;
                    }
                    AsymmetricKeyPreCalculator.load(f.getAbsolutePath(), true);
                    ret = f.delete();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error merging file " + f.getAbsolutePath(), e);
                }
                ret &= f.delete();
            }
            return ret;
        }

        private void calculateKey(AlgorithmParameter p) {
            try {
                Thread t = this.runCalculatorThread(p);
                t.setName("Precalc precalculation");
                t.setPriority(1);
                t.setDaemon(true);
                pool.execute(t);
                LOGGER.log(Level.FINE, "Added key precalculator for " + String.valueOf(p) + " (pool size:" + pool.getQueue().size() + "; thread count (min/current/max):" + pool.getCorePoolSize() + "/" + pool.getActiveCount() + "/" + pool.getMaximumPoolSize() + ")");
                if (pool.getQueue().size() > Math.max(incrementor * 2, numThreads)) {
                    pool.awaitTermination(10L, TimeUnit.SECONDS);
                    if (tempdir != null) {
                        cache.showStats();
                        LOGGER.log(Level.INFO, "|Running threads " + pool.getActiveCount() + " of " + pool.getQueue().size());
                    }
                    if (pool.getQueue().size() > incrementor && pool.getQueue().size() < incrementor * 2 && tempdir != null) {
                        incrementor = Math.max(1, incrementor / 2);
                        LOGGER.log(Level.INFO, "lowered incrementor to " + incrementor);
                    } else if (pool.getQueue().size() < numThreads && tempdir != null) {
                        LOGGER.log(Level.INFO, "raised incrementor to " + (incrementor *= 2));
                    }
                    AsymmetricKeyPreCalculator.save();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "exception while storing file", ioe);
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }

        private Thread runCalculatorThread(AlgorithmParameter param) {
            return new CalculationThread(param);
        }
    }

    private static class CalculationThread
    extends Thread {
        private final AlgorithmParameter param;

        public CalculationThread(AlgorithmParameter param) {
            this.param = new AlgorithmParameter(param);
        }

        @Override
        public void run() {
            LOGGER.log(Level.FINE, "precalculating key " + String.valueOf(this.param));
            try {
                long start = System.currentTimeMillis();
                AsymmetricKey ak = new AsymmetricKey(new AlgorithmParameter(this.param), false);
                cache.setCalcTime(new AlgorithmParameter(this.param), System.currentTimeMillis() - start);
                cache.push(ak);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "got unexpected exception", ioe);
            }
        }
    }
}

