/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.EllipticCurveType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import net.messagevortex.asn1.encryption.Parameter;
import net.messagevortex.asn1.encryption.SecurityLevel;

public enum Algorithm implements Serializable
{
    AES128(1000, AlgorithmType.SYMMETRIC, "aes128", "BC", SecurityLevel.LOW),
    AES192(1001, AlgorithmType.SYMMETRIC, "aes192", "BC", SecurityLevel.MEDIUM),
    AES256(1002, AlgorithmType.SYMMETRIC, "aes256", "BC", SecurityLevel.QUANTUM),
    CAMELLIA128(1100, AlgorithmType.SYMMETRIC, "CAMELLIA128", "BC", SecurityLevel.LOW),
    CAMELLIA192(1101, AlgorithmType.SYMMETRIC, "CAMELLIA192", "BC", SecurityLevel.MEDIUM),
    CAMELLIA256(1102, AlgorithmType.SYMMETRIC, "CAMELLIA256", "BC", SecurityLevel.QUANTUM),
    EC(2600, AlgorithmType.ASYMMETRIC, "ECIES", "BC", Algorithm.getSecLevelList(Algorithm.getSecLevelList(Algorithm.getSecLevelList(EllipticCurveType.SECP384R1.getSecurityLevel(), Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=ECIES", String.valueOf(Parameter.KEYSIZE) + "=384", String.valueOf(Parameter.BLOCKSIZE) + "=384", String.valueOf(Parameter.CURVETYPE) + "=" + String.valueOf((Object)((Object)EllipticCurveType.SECP384R1)), String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))})), EllipticCurveType.SECT409K1.getSecurityLevel(), Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=ECIES", String.valueOf(Parameter.KEYSIZE) + "=409", String.valueOf(Parameter.BLOCKSIZE) + "=409", String.valueOf(Parameter.CURVETYPE) + "=" + String.valueOf((Object)((Object)EllipticCurveType.SECT409K1)), String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))})), EllipticCurveType.SECP521R1.getSecurityLevel(), Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=ECIES", String.valueOf(Parameter.KEYSIZE) + "=521", String.valueOf(Parameter.BLOCKSIZE) + "=521", String.valueOf(Parameter.CURVETYPE) + "=" + String.valueOf((Object)((Object)EllipticCurveType.SECP521R1)), String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))}))),
    RIPEMD160(3100, AlgorithmType.HASHING, "ripemd160", "BC", SecurityLevel.LOW),
    RSA(2000, AlgorithmType.ASYMMETRIC, "RSA", "BC", Algorithm.getSecLevelList(Algorithm.getSecLevelList(Algorithm.getSecLevelList(Algorithm.getSecLevelList(SecurityLevel.LOW, Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=RSA", String.valueOf(Parameter.KEYSIZE) + "=1024", String.valueOf(Parameter.BLOCKSIZE) + "=1024", String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))})), SecurityLevel.MEDIUM, Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=RSA", String.valueOf(Parameter.KEYSIZE) + "=2048", String.valueOf(Parameter.BLOCKSIZE) + "=2048", String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))})), SecurityLevel.HIGH, Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=RSA", String.valueOf(Parameter.KEYSIZE) + "=4096", String.valueOf(Parameter.BLOCKSIZE) + "=4096", String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))})), SecurityLevel.QUANTUM, Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=RSA", String.valueOf(Parameter.KEYSIZE) + "=8192", String.valueOf(Parameter.BLOCKSIZE) + "=8192", String.valueOf(Parameter.MODE) + "=" + String.valueOf((Object)((Object)Mode.getDefault(AlgorithmType.ASYMMETRIC))), String.valueOf(Parameter.PADDING) + "=" + String.valueOf(Padding.getDefault(AlgorithmType.ASYMMETRIC))}))),
    SHA256(3000, AlgorithmType.HASHING, "sha256", "BC", SecurityLevel.MEDIUM),
    SHA384(3001, AlgorithmType.HASHING, "sha384", "BC", SecurityLevel.HIGH),
    SHA512(3002, AlgorithmType.HASHING, "sha512", "BC", SecurityLevel.QUANTUM),
    TWOFISH128(1200, AlgorithmType.SYMMETRIC, "TWOFISH128", "BC", SecurityLevel.LOW),
    TWOFISH192(1201, AlgorithmType.SYMMETRIC, "TWOFISH192", "BC", SecurityLevel.MEDIUM),
    TWOFISH256(1202, AlgorithmType.SYMMETRIC, "TWOFISH256", "BC", SecurityLevel.QUANTUM);

    public static final long serialVersionUID = 100000000039L;
    private static final Logger LOGGER;
    private final Set<String> fixed_sizes = Arrays.stream(new String[]{"aes", "sha", "camellia", "twofish", "ripemd"}).collect(Collectors.toSet());
    private final int id;
    private final AlgorithmType algType;
    private final String txt;
    private final String provider;
    private final Map<SecurityLevel, AlgorithmParameter> secLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm(int id, AlgorithmType algType, String txt, String provider, SecurityLevel level) {
        if (txt == null) {
            throw new NullPointerException(" textual representation may not be null");
        }
        Map<SecurityLevel, AlgorithmParameter> map = this.secLevel = new ConcurrentHashMap<SecurityLevel, AlgorithmParameter>();
        synchronized (map) {
            this.id = id;
            this.algType = algType;
            this.txt = txt;
            this.provider = provider;
            int blockSize = this.getKeySize();
            if (txt.toLowerCase().startsWith("aes") || txt.toLowerCase().startsWith("camellia") || txt.toLowerCase().startsWith("twofish")) {
                blockSize = 128;
            }
            this.secLevel.putAll(Algorithm.getSecLevelList(level, Algorithm.getParameterList(new String[]{String.valueOf(Parameter.ALGORITHM) + "=" + id, String.valueOf(Parameter.KEYSIZE) + "=" + this.getKeySize(), String.valueOf(Parameter.BLOCKSIZE) + "=" + blockSize})));
            if (algType == AlgorithmType.SYMMETRIC) {
                this.secLevel.get((Object)level).put(Parameter.PADDING.getId(), Padding.getDefault(algType).toString());
                this.secLevel.get((Object)level).put(Parameter.MODE.getId(), Mode.getDefault(algType).toString());
            }
        }
    }

    private Algorithm(int id, AlgorithmType algType, String txt, String provider, Map<SecurityLevel, AlgorithmParameter> parameters) {
        this.id = id;
        this.algType = algType;
        this.txt = txt;
        this.provider = provider;
        this.secLevel = new HashMap<SecurityLevel, AlgorithmParameter>();
        for (Map.Entry<SecurityLevel, AlgorithmParameter> e : parameters.entrySet()) {
            try {
                this.secLevel.put(e.getKey(), new AlgorithmParameter(e.getValue().toAsn1Object(DumpType.INTERNAL)));
            }
            catch (IOException ex) {
                throw new IllegalAccessError("unable to clone parameter map");
            }
        }
    }

    private static AlgorithmParameter getParameterList(String[] txt) {
        AlgorithmParameter ret = new AlgorithmParameter();
        for (String s : txt) {
            String[] kv = s.split("=");
            if (kv.length == 2) {
                ret.put(kv[0], kv[1]);
                continue;
            }
            LOGGER.log(Level.WARNING, "split of \"" + s + "\" failed");
        }
        return ret;
    }

    private static Map<SecurityLevel, AlgorithmParameter> getSecLevelList(SecurityLevel level, AlgorithmParameter o) {
        ConcurrentHashMap<SecurityLevel, AlgorithmParameter> ret = new ConcurrentHashMap<SecurityLevel, AlgorithmParameter>();
        return Algorithm.getSecLevelList(ret, level, o);
    }

    private static Map<SecurityLevel, AlgorithmParameter> getSecLevelList(Map<SecurityLevel, AlgorithmParameter> lst, SecurityLevel level, AlgorithmParameter o) {
        EnumMap<SecurityLevel, AlgorithmParameter> ret = new EnumMap<SecurityLevel, AlgorithmParameter>(SecurityLevel.class);
        ret.putAll(lst);
        ret.put(level, o);
        return ret;
    }

    public static Algorithm[] getAlgorithms(AlgorithmType at) {
        Algorithm[] a = Algorithm.values();
        ArrayList<Algorithm> v = new ArrayList<Algorithm>(a.length);
        for (Algorithm e : a) {
            if (e.algType != at) continue;
            v.add(e);
        }
        return v.toArray(new Algorithm[v.size()]);
    }

    public static Algorithm getById(int id) {
        for (Algorithm e : Algorithm.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public static Algorithm getByString(String s) {
        for (Algorithm e : Algorithm.values()) {
            if (!e.toString().equalsIgnoreCase(s)) continue;
            return e;
        }
        return null;
    }

    public static Algorithm getDefault(AlgorithmType at) {
        switch (at) {
            case ASYMMETRIC: {
                return RSA;
            }
            case SYMMETRIC: {
                return AES256;
            }
            case HASHING: {
                return SHA384;
            }
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String getAlgorithmFamily() {
        return this.txt.replaceAll("[0-9]*$", "");
    }

    public String toString() {
        return this.txt;
    }

    public AlgorithmType getAlgorithmType() {
        return this.algType;
    }

    public String getProvider() {
        return this.provider;
    }

    public int getKeySize() {
        return this.getKeySize(SecurityLevel.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeySize(SecurityLevel sl) {
        for (String i2 : this.fixed_sizes) {
            if (!this.txt.toLowerCase().startsWith(i2)) continue;
            return Integer.parseInt(this.txt.substring(i2.length(), i2.length() + 3));
        }
        Map<SecurityLevel, AlgorithmParameter> map = this.secLevel;
        synchronized (map) {
            AlgorithmParameter params = this.getParameters(sl);
            if (params == null || Integer.parseInt(params.get(Parameter.KEYSIZE.getId())) < 10) {
                LOGGER.log(Level.SEVERE, "Error fetching keysize for " + this.txt + "/" + String.valueOf((Object)sl) + " (" + String.valueOf(this.secLevel.get((Object)sl)) + ")");
                throw new IllegalArgumentException("Error fetching key size for " + this.txt + "/" + String.valueOf((Object)sl) + " (" + String.valueOf(this.secLevel.get((Object)sl)) + ")");
            }
            if (params.get(Parameter.ALGORITHM).toUpperCase().startsWith("ECIES")) {
                return Integer.parseInt(params.get(Parameter.CURVETYPE).substring(4, 7));
            }
            return Integer.parseInt(params.get(Parameter.KEYSIZE));
        }
    }

    public int getBlockSize() {
        return this.getBlockSize(SecurityLevel.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockSize(SecurityLevel sl) {
        Map<SecurityLevel, AlgorithmParameter> map = this.secLevel;
        synchronized (map) {
            AlgorithmParameter params = this.getParameters(sl);
            if (params == null) {
                return -1;
            }
            String bsparam = params.get(Parameter.BLOCKSIZE);
            if (bsparam != null) {
                return Integer.parseInt(bsparam);
            }
            return this.getKeySize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmParameter getParameters(SecurityLevel sl) {
        Map<SecurityLevel, AlgorithmParameter> map = this.secLevel;
        synchronized (map) {
            AlgorithmParameter params = null;
            while (params == null) {
                params = this.secLevel.get((Object)sl);
                if (params != null) continue;
                sl = sl.next();
            }
            try {
                return new AlgorithmParameter(params.toAsn1Object(DumpType.ALL));
            }
            catch (IOException exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<SecurityLevel, AlgorithmParameter> getParameters() {
        Map<SecurityLevel, AlgorithmParameter> map = this.secLevel;
        synchronized (map) {
            HashMap<SecurityLevel, AlgorithmParameter> ret = new HashMap<SecurityLevel, AlgorithmParameter>(this.secLevel.size());
            for (Map.Entry<SecurityLevel, AlgorithmParameter> e : this.secLevel.entrySet()) {
                ret.put(e.getKey(), new AlgorithmParameter(e.getValue()));
            }
            return ret;
        }
    }

    static {
        LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    }
}

