/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.messagevortex.AbstractDaemon;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.accounting.Accountant;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.blender.Blender;
import net.messagevortex.router.Router;

public class SimpleRouterImplementation
extends AbstractDaemon
implements Router {
    private Accountant accountant;
    private final Map<String, Blender> blenders = new HashMap<String, Blender>();

    public SimpleRouterImplementation(String section) {
        this.setAccountant(MessageVortexRepository.getAccountant("", section));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBlendingLayer(Blender blendingLayer) {
        String id = blendingLayer.getBlendingAddress();
        blendingLayer.setBlenderReceiver(this);
        Map<String, Blender> map = this.blenders;
        synchronized (map) {
            this.blenders.put(id, blendingLayer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBlendingLayer(Blender blendingLayer) {
        if (!this.blenders.containsValue(blendingLayer)) {
            return false;
        }
        Map<String, Blender> map = this.blenders;
        synchronized (map) {
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry<String, Blender> entry : this.blenders.entrySet()) {
                if (Objects.equals(blendingLayer, entry.getValue())) {
                    keys.add(entry.getKey());
                }
                for (String key : keys) {
                    this.blenders.remove(key);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Blender> getAllBlendingLayer() {
        Map<String, Blender> map = this.blenders;
        synchronized (map) {
            return new ArrayList<Blender>(this.blenders.values());
        }
    }

    @Override
    public final Accountant setAccountant(Accountant accountant) {
        Accountant ret = this.getAccountant();
        this.accountant = accountant;
        return ret;
    }

    @Override
    public Accountant getAccountant() {
        return this.accountant;
    }

    @Override
    public boolean gotMessage(VortexMessage message) {
        return false;
    }
}

