/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.messagevortex.MessageVortexLogger;

public class SocketDeblocker
extends Thread {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final int timeout;
    private final int port;
    private volatile boolean shutdown = false;

    public SocketDeblocker(int port, int timeout) {
        this.port = port;
        this.timeout = timeout;
    }

    public void shutdown() {
        this.shutdown = true;
        while (this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.FINEST, "Interrupted exception while shutting down deblocking socket", ie);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        int countdown = this.timeout / 10;
        while (!this.shutdown && countdown > 0) {
            --countdown;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.FINEST, "Interrupted exception while running SocketDeblocker", ie);
                Thread.currentThread().interrupt();
            }
        }
        if (!this.shutdown) {
            try {
                SSLSocket cs = (SSLSocket)SSLSocketFactory.getDefault().createSocket("localhost", this.port);
                cs.close();
            }
            catch (ConnectException e) {
                LOGGER.log(Level.FINEST, "Exception while running SocketDeblocker", e);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Exception while running SocketDeblocker", e);
            }
        }
    }
}

