/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.Arrays;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private final Select instruction;

    private static boolean matchIsOrdered(int[] match, int matchLength, int maxGap) {
        for (int i2 = 1; i2 < matchLength; ++i2) {
            if (match[i2] - match[i2 - 1] <= maxGap) continue;
            return false;
        }
        return true;
    }

    private static void sort(int l, int r, int[] match, InstructionHandle[] targets) {
        int i2 = l;
        int j = r;
        int m = match[l + r >>> 1];
        while (true) {
            if (match[i2] < m) {
                ++i2;
                continue;
            }
            while (m < match[j]) {
                --j;
            }
            if (i2 <= j) {
                int h = match[i2];
                match[i2] = match[j];
                match[j] = h;
                InstructionHandle h2 = targets[i2];
                targets[i2] = targets[j];
                targets[j] = h2;
                ++i2;
                --j;
            }
            if (i2 > j) break;
        }
        if (l < j) {
            SWITCH.sort(l, j, match, targets);
        }
        if (i2 < r) {
            SWITCH.sort(i2, r, match, targets);
        }
    }

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        this(match, targets, target, 1);
    }

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target, int maxGap) {
        int[] matchClone = (int[])match.clone();
        InstructionHandle[] targetsClone = (InstructionHandle[])targets.clone();
        int matchLength = match.length;
        if (matchLength < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            SWITCH.sort(0, matchLength - 1, matchClone, targetsClone);
            if (SWITCH.matchIsOrdered(matchClone, matchLength, maxGap)) {
                int maxSize = matchLength + matchLength * maxGap;
                int[] mVec = new int[maxSize];
                InstructionHandle[] tVec = new InstructionHandle[maxSize];
                int count = 1;
                mVec[0] = match[0];
                tVec[0] = targets[0];
                for (int i2 = 1; i2 < matchLength; ++i2) {
                    int prev = match[i2 - 1];
                    int gap = match[i2] - prev;
                    for (int j = 1; j < gap; ++j) {
                        mVec[count] = prev + j;
                        tVec[count] = target;
                        ++count;
                    }
                    mVec[count] = match[i2];
                    tVec[count] = targets[i2];
                    ++count;
                }
                this.instruction = new TABLESWITCH(Arrays.copyOf(mVec, count), Arrays.copyOf(tVec, count), target);
            } else {
                this.instruction = new LOOKUPSWITCH(matchClone, targetsClone, target);
            }
        }
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }
}

