/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.apt;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.MutableAttributeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.apt.AptMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AptSink
extends AbstractTextSink
implements AptMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(AptSink.class);
    private StringBuffer buffer;
    private StringBuilder tableCaptionBuffer;
    private Collection<String> authors;
    private String title;
    private String date;
    private boolean startFlag;
    private boolean tableCaptionFlag;
    private boolean tableCellFlag;
    private boolean headerFlag;
    private boolean bufferFlag;
    private boolean itemFlag;
    private boolean verbatimFlag;
    private boolean isSource;
    private boolean gridFlag;
    private int cellCount;
    private final PrintWriter writer;
    private int[] cellJustif;
    private String rowLine;
    private String listNestingIndent;
    private final Stack<String> listStyles;
    protected Stack<List<String>> inlineStack = new Stack();

    protected AptSink(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.listStyles = new Stack();
        this.init();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headerFlag = headFlag;
    }

    @Override
    protected void init() {
        super.init();
        this.resetBuffer();
        this.tableCaptionBuffer = new StringBuilder();
        this.listNestingIndent = "";
        this.authors = new LinkedList<String>();
        this.title = null;
        this.date = null;
        this.startFlag = true;
        this.tableCaptionFlag = false;
        this.tableCellFlag = false;
        this.headerFlag = false;
        this.bufferFlag = false;
        this.itemFlag = false;
        this.verbatimFlag = false;
        this.isSource = false;
        this.gridFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.rowLine = null;
        this.listStyles.clear();
        this.inlineStack.clear();
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    protected void resetTableCaptionBuffer() {
        this.tableCaptionBuffer = new StringBuilder();
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        boolean startFlag = this.startFlag;
        this.init();
        this.headerFlag = true;
        this.startFlag = startFlag;
    }

    @Override
    public void head_() {
        this.headerFlag = false;
        if (!this.startFlag) {
            this.write(EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        if (this.title != null) {
            this.write(" " + this.title + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        for (String author : this.authors) {
            this.write(" " + author + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        if (this.date != null) {
            this.write(" " + this.date + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
    }

    @Override
    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    @Override
    public void author_() {
        if (this.buffer.length() > 0) {
            this.authors.add(this.buffer.toString());
            this.resetBuffer();
        }
    }

    @Override
    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    @Override
    public void section_(int level) {
        this.write(EOL);
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level > 5) {
            LOGGER.warn("{}Replacing unsupported section title level {} in APT with level 5", (Object)this.getLocationLogPrefix(), (Object)level);
            level = 5;
        }
        if (level == 1) {
            this.write(EOL);
        } else if (level > 1) {
            this.write(EOL + StringUtils.repeat(SECTION_TITLE_START_MARKUP, level - 1));
        }
    }

    @Override
    public void sectionTitle_(int level) {
        if (level >= 1) {
            this.write(EOL + EOL);
        }
    }

    @Override
    public void list(SinkEventAttributes attributes) {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push(LIST_START_MARKUP);
        this.write(EOL);
    }

    @Override
    public void list_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.removeEnd(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void listItem(SinkEventAttributes attributes) {
        this.numberedListItem();
        this.itemFlag = true;
    }

    @Override
    public void listItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        String style;
        this.listNestingIndent = this.listNestingIndent + " ";
        this.write(EOL);
        switch (numbering) {
            case 2: {
                style = String.valueOf('A');
                break;
            }
            case 1: {
                style = String.valueOf('a');
                break;
            }
            case 4: {
                style = String.valueOf('I');
                break;
            }
            case 3: {
                style = String.valueOf('i');
                break;
            }
            default: {
                style = String.valueOf('1');
            }
        }
        this.listStyles.push(style);
    }

    @Override
    public void numberedList_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.removeEnd(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        String style = this.listStyles.peek();
        if (style.equals(String.valueOf('*'))) {
            this.write(EOL + this.listNestingIndent + '*' + ' ');
        } else {
            this.write(EOL + this.listNestingIndent + '[' + '[' + style + ']' + ']' + ' ');
        }
        this.itemFlag = true;
    }

    @Override
    public void numberedListItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void definitionList(SinkEventAttributes attributes) {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push("");
        this.write(EOL);
    }

    @Override
    public void definitionList_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.removeEnd(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        this.write(EOL + " [");
    }

    @Override
    public void definedTerm_() {
        this.write("] ");
    }

    @Override
    public void definition(SinkEventAttributes attributes) {
        this.itemFlag = true;
    }

    @Override
    public void definition_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void pageBreak() {
        this.write(EOL + '\f' + EOL);
    }

    @Override
    public void paragraph(SinkEventAttributes attributes) {
        if (!this.tableCellFlag) {
            if (this.itemFlag) {
                this.write(EOL + EOL + "  " + this.listNestingIndent);
            } else {
                this.write(EOL + " ");
            }
        }
    }

    @Override
    public void paragraph_() {
        if (!this.tableCellFlag) {
            this.write(EOL + EOL);
        }
    }

    @Override
    public void verbatim(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        boolean source = false;
        if (atts != null && atts.isDefined("decoration")) {
            source = "source".equals(atts.getAttribute("decoration").toString());
        }
        this.verbatimFlag = true;
        this.isSource = source;
        this.write(EOL);
        if (source) {
            this.write(EOL + VERBATIM_SOURCE_START_MARKUP + EOL);
        } else {
            this.write(EOL + VERBATIM_START_MARKUP + EOL);
        }
    }

    @Override
    public void verbatim_() {
        if (this.isSource) {
            this.write(EOL + VERBATIM_SOURCE_END_MARKUP + EOL);
        } else {
            this.write(EOL + VERBATIM_END_MARKUP + EOL);
        }
        this.isSource = false;
        this.verbatimFlag = false;
    }

    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        this.write(EOL + HORIZONTAL_RULE_MARKUP + EOL);
    }

    @Override
    public void table(SinkEventAttributes attributes) {
        this.write(EOL);
    }

    @Override
    public void table_() {
        if (this.rowLine != null) {
            this.write(this.rowLine);
        }
        this.rowLine = null;
        if (this.tableCaptionBuffer.length() > 0) {
            this.text(this.tableCaptionBuffer.toString() + EOL);
        }
        this.resetTableCaptionBuffer();
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = justification;
        this.gridFlag = grid;
    }

    @Override
    public void tableRows_() {
        this.cellJustif = null;
        this.gridFlag = false;
    }

    @Override
    public void tableRow(SinkEventAttributes attributes) {
        this.bufferFlag = true;
        this.cellCount = 0;
    }

    @Override
    public void tableRow_() {
        this.bufferFlag = false;
        this.buildRowLine();
        this.write(this.rowLine);
        if (this.gridFlag) {
            this.write(TABLE_ROW_SEPARATOR_MARKUP);
        }
        this.write(this.buffer.toString());
        this.resetBuffer();
        this.write(EOL);
        this.cellCount = 0;
    }

    private void buildRowLine() {
        StringBuilder rLine = new StringBuilder();
        rLine.append(TABLE_ROW_START_MARKUP);
        for (int i2 = 0; i2 < this.cellCount; ++i2) {
            if (this.cellJustif != null) {
                switch (this.cellJustif[i2]) {
                    case 1: {
                        rLine.append(TABLE_COL_LEFT_ALIGNED_MARKUP);
                        break;
                    }
                    case 2: {
                        rLine.append(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                        break;
                    }
                    default: {
                        rLine.append(TABLE_COL_CENTERED_ALIGNED_MARKUP);
                        break;
                    }
                }
                continue;
            }
            rLine.append(TABLE_COL_CENTERED_ALIGNED_MARKUP);
        }
        rLine.append(EOL);
        this.rowLine = rLine.toString();
    }

    @Override
    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false);
    }

    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        if (headerRow) {
            this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        }
        this.tableCellFlag = true;
    }

    @Override
    public void tableCell_() {
        this.endTableCell();
    }

    @Override
    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.tableCellFlag = false;
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        this.tableCaptionFlag = true;
    }

    @Override
    public void tableCaption_() {
        this.tableCaptionFlag = false;
    }

    @Override
    public void figureCaption_() {
        this.write(EOL);
    }

    @Override
    public void figureGraphics(String name, SinkEventAttributes attributes) {
        this.write(EOL + "[" + name + "] ");
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        this.write(ANCHOR_START_MARKUP);
    }

    @Override
    public void anchor_() {
        this.write(ANCHOR_END_MARKUP);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        if (!this.headerFlag) {
            this.write(LINK_START_1_MARKUP);
            this.text(name.startsWith("#") ? name.substring(1) : name);
            this.write(LINK_START_2_MARKUP);
        }
    }

    @Override
    public void link_() {
        if (!this.headerFlag) {
            this.write(LINK_END_MARKUP);
        }
    }

    public void link(String name, String target) {
        if (!this.headerFlag) {
            this.write(LINK_START_1_MARKUP);
            this.text(target);
            this.write(LINK_START_2_MARKUP);
            this.text(name);
        }
    }

    @Override
    public void inline(SinkEventAttributes attributes) {
        if (!this.headerFlag) {
            ArrayList<String> tags = new ArrayList<String>();
            if (attributes != null) {
                if (attributes.containsAttribute("semantics", "italic")) {
                    this.write(ITALIC_START_MARKUP);
                    tags.add(0, ITALIC_END_MARKUP);
                }
                if (attributes.containsAttribute("semantics", "bold")) {
                    this.write(BOLD_START_MARKUP);
                    tags.add(0, BOLD_END_MARKUP);
                }
                if (attributes.containsAttribute("semantics", "code")) {
                    this.write(MONOSPACED_START_MARKUP);
                    tags.add(0, MONOSPACED_END_MARKUP);
                }
            }
            this.inlineStack.push(tags);
        }
    }

    @Override
    public void inline_() {
        if (!this.headerFlag) {
            for (String tag : this.inlineStack.pop()) {
                this.write(tag);
            }
        }
    }

    @Override
    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    @Override
    public void italic_() {
        this.inline_();
    }

    @Override
    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    @Override
    public void bold_() {
        this.inline_();
    }

    @Override
    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    @Override
    public void monospaced_() {
        this.inline_();
    }

    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(EOL);
        } else if (this.verbatimFlag) {
            this.write(EOL);
        } else {
            this.write("\\" + EOL);
        }
    }

    @Override
    public void nonBreakingSpace() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(NON_BREAKING_SPACE_MARKUP);
        } else {
            this.write(NON_BREAKING_SPACE_MARKUP);
        }
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        if (attributes != null) {
            this.inline(attributes);
        }
        if (this.tableCaptionFlag) {
            this.tableCaptionBuffer.append(text);
        } else if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
        if (attributes != null) {
            this.inline_();
        }
    }

    @Override
    public void rawText(String text) {
        this.write(text);
    }

    @Override
    public void comment(String comment) {
        this.rawText((this.startFlag ? "" : EOL) + '~' + '~' + comment);
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        LOGGER.warn("{}Unknown Sink event '{}', ignoring!", (Object)this.getLocationLogPrefix(), (Object)name);
    }

    protected void write(String text) {
        this.startFlag = false;
        if (this.tableCellFlag) {
            this.buffer.append(text);
        } else {
            this.writer.write(AptSink.unifyEOLs(text));
        }
    }

    protected void content(String text) {
        this.write(AptSink.escapeAPT(text));
    }

    protected void verbatimContent(String text) {
        this.write(AptSink.escapeAPT(text));
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeAPT(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i2 = 0; i2 < length; ++i2) {
            char c = text.charAt(i2);
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

