/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.checkout;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.remoteinfo.GitRemoteInfoCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitCheckOutCommand
extends AbstractCheckOutCommand
implements GitCommand {
    private final Map<String, String> environmentVariables;

    public GitCheckOutCommand(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public ScmResult executeCommand(ScmProviderRepository repo, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        int exitCode;
        ScmVersion version = parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        boolean binary = parameters.getBoolean(CommandParameter.BINARY, false);
        boolean shallow = parameters.getBoolean(CommandParameter.SHALLOW, false);
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        String lastCommandLine = "git-nothing-to-do";
        if (!fileSet.getBasedir().exists() || !new File(fileSet.getBasedir(), ".git").exists()) {
            Commandline clClone;
            if (fileSet.getBasedir().exists()) {
                fileSet.getBasedir().delete();
            }
            if ((exitCode = GitCommandLineUtils.execute(clClone = this.createCloneCommand(repository, fileSet.getBasedir(), version, binary, shallow), stdout, stderr)) != 0) {
                return new CheckOutScmResult(clClone.toString(), "The git-clone command failed.", stderr.getOutput(), false);
            }
            lastCommandLine = clClone.toString();
        }
        GitRemoteInfoCommand gitRemoteInfoCommand = new GitRemoteInfoCommand(this.environmentVariables);
        RemoteInfoScmResult result = gitRemoteInfoCommand.executeRemoteInfoCommand(repository, null, null);
        if (fileSet.getBasedir().exists() && new File(fileSet.getBasedir(), ".git").exists() && result.getBranches().size() > 0) {
            Commandline clPull = this.createPullCommand(repository, fileSet.getBasedir(), version);
            exitCode = GitCommandLineUtils.execute(clPull, stdout, stderr);
            if (exitCode != 0) {
                return new CheckOutScmResult(clPull.toString(), "The git-pull command failed.", stderr.getOutput(), false);
            }
            lastCommandLine = clPull.toString();
            Commandline clCheckout = GitCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), version);
            exitCode = GitCommandLineUtils.execute(clCheckout, stdout, stderr);
            if (exitCode != 0) {
                return new CheckOutScmResult(clCheckout.toString(), "The git-checkout command failed.", stderr.getOutput(), false);
            }
            lastCommandLine = clCheckout.toString();
        }
        GitListConsumer listConsumer = new GitListConsumer(fileSet.getBasedir(), ScmFileStatus.CHECKED_IN);
        Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute(clList, listConsumer, stderr);
        if (exitCode != 0) {
            return new CheckOutScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(lastCommandLine, listConsumer.getListedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "checkout");
        if (version != null && StringUtils.isNotEmpty(version.getName())) {
            cl.createArg().setValue(version.getName());
        }
        return cl;
    }

    private Commandline createCloneCommand(GitScmProviderRepository repository, File workingDirectory, ScmVersion version, boolean binary, boolean shallow) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory.getParentFile(), "clone", repository, this.environmentVariables);
        this.forceBinary(cl, binary);
        if (shallow) {
            cl.createArg().setValue("--depth");
            cl.createArg().setValue("1");
        }
        if (version != null && version instanceof ScmBranch) {
            cl.createArg().setValue("--branch");
            cl.createArg().setValue(version.getName());
        }
        cl.createArg().setValue(repository.getFetchUrl());
        cl.createArg().setValue(workingDirectory.getName());
        return cl;
    }

    private void forceBinary(Commandline cl, boolean binary) {
        if (binary) {
            cl.createArg().setValue("-c");
            cl.createArg().setValue("core.autocrlf=false");
        }
    }

    private Commandline createPullCommand(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Commandline cl;
        if (version != null && StringUtils.isNotEmpty(version.getName())) {
            if (version instanceof ScmTag) {
                cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "fetch", repository, this.environmentVariables);
                cl.createArg().setValue(repository.getFetchUrl());
            } else {
                cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull", repository, this.environmentVariables);
                cl.createArg().setValue(repository.getFetchUrl());
                cl.createArg().setValue(version.getName() + ":" + version.getName());
            }
        } else {
            cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull", repository, this.environmentVariables);
            cl.createArg().setValue(repository.getFetchUrl());
            cl.createArg().setValue("master");
        }
        return cl;
    }

    @Override
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        throw new UnsupportedOperationException("Should not get here");
    }
}

