/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.info;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.info.GitInfoConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitInfoCommand
extends AbstractCommand
implements GitCommand {
    public static final int NO_REVISION_LENGTH = -1;

    @Override
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        Commandline baseCli = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "log");
        baseCli.createArg().setValue("-1");
        baseCli.createArg().setValue("--no-merges");
        baseCli.addArg(GitInfoConsumer.getFormatArgument());
        LinkedList<InfoItem> infoItems = new LinkedList<InfoItem>();
        if (fileSet.getFileList().isEmpty()) {
            infoItems.add(this.executeInfoCommand(baseCli, parameters, fileSet.getBasedir()));
        } else {
            for (File scmFile : fileSet.getFileList()) {
                baseCli = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "log");
                baseCli.createArg().setValue("-1");
                baseCli.createArg().setValue("--no-merges");
                baseCli.addArg(GitInfoConsumer.getFormatArgument());
                baseCli.createArg().setValue("--");
                GitCommandLineUtils.addTarget(baseCli, Collections.singletonList(scmFile));
                infoItems.add(this.executeInfoCommand(baseCli, parameters, scmFile));
            }
        }
        return new InfoScmResult(baseCli.toString(), infoItems);
    }

    protected InfoItem executeInfoCommand(Commandline cli, CommandParameters parameters, File scmFile) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitInfoConsumer consumer = new GitInfoConsumer(scmFile.toPath(), GitInfoCommand.getRevisionLength(parameters));
        int exitCode = GitCommandLineUtils.execute(cli, consumer, stderr = new CommandLineUtils.StringStreamConsumer());
        if (exitCode != 0) {
            throw new ScmException("The git log command failed: " + cli.toString() + " returned " + stderr.getOutput());
        }
        return consumer.getInfoItem();
    }

    private static int getRevisionLength(CommandParameters parameters) throws ScmException {
        if (parameters == null) {
            return -1;
        }
        return parameters.getInt(CommandParameter.SCM_SHORT_REVISION_LENGTH, -1);
    }
}

