/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.tag;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.inventory.HgListConsumer;
import org.apache.maven.scm.provider.hg.command.tag.HgTagConsumer;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;

public class HgTagCommand
extends AbstractTagCommand
implements Command {
    @Override
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        return this.executeTagCommand(scmProviderRepository, fileSet, tag, new ScmTagParameters(message));
    }

    @Override
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory : " + fileSet.getFileList());
        }
        File workingDir = fileSet.getBasedir();
        String[] tagCmd = new String[]{"tag", "--message", scmTagParameters.getMessage(), tag};
        StringBuilder cmd = this.joinCmd(tagCmd);
        HgTagConsumer consumer = new HgTagConsumer();
        ScmResult result = HgUtils.execute(consumer, workingDir, tagCmd);
        HgScmProviderRepository repository = (HgScmProviderRepository)scmProviderRepository;
        if (result.isSuccess()) {
            if (repository.isPushChanges() && !repository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
                String branchName = HgUtils.getCurrentBranchName(workingDir);
                boolean differentOutgoingBranch = HgUtils.differentOutgoingBranchFound(workingDir, branchName);
                String[] pushCmd = new String[]{"push", differentOutgoingBranch ? "-r" + branchName : null, repository.getURI()};
                result = HgUtils.execute(new HgConsumer(), fileSet.getBasedir(), pushCmd);
            }
        } else {
            throw new ScmException("Error while executing command " + cmd.toString());
        }
        String[] listCmd = new String[]{"locate"};
        HgListConsumer listconsumer = new HgListConsumer();
        result = HgUtils.execute(listconsumer, fileSet.getBasedir(), listCmd);
        if (result.isSuccess()) {
            List<ScmFile> files = listconsumer.getFiles();
            ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
            for (ScmFile f : files) {
                if (f.getPath().endsWith(".hgtags")) continue;
                fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
            }
            return new TagScmResult(fileList, result);
        }
        throw new ScmException("Error while executing command " + cmd.toString());
    }

    private StringBuilder joinCmd(String[] cmd) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < cmd.length; ++i2) {
            String s = cmd[i2];
            result.append(s);
            if (i2 >= cmd.length - 1) continue;
            result.append(" ");
        }
        return result;
    }
}

