/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.codehaus.plexus.util.FileUtils;

@Singleton
@Named(value="filename")
public class FilenameExposer
implements JarIdentificationExposer {
    private static final Pattern VERSION_PATTERN = Pattern.compile("-\\d");

    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        String filename = FileUtils.removeExtension(jarAnalyzer.getFile().getName());
        Matcher mat = VERSION_PATTERN.matcher(filename);
        if (mat.find()) {
            String prefix = filename.substring(0, mat.start());
            identification.addArtifactId(prefix);
            identification.addName(prefix);
            identification.addVersion(filename.substring(mat.end() - 1));
        } else {
            identification.addArtifactId(filename);
            identification.addName(filename);
        }
    }
}

