/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

class StreamPollFeeder
extends Thread {
    public static final int BUF_LEN = 80;
    private final InputStream input;
    private final OutputStream output;
    private Throwable exception;
    private boolean done;
    private final Object lock = new Object();

    StreamPollFeeder(InputStream input, OutputStream output) {
        this.input = Objects.requireNonNull(input);
        this.output = Objects.requireNonNull(output);
        this.done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buf = new byte[80];
        try {
            while (!this.done) {
                if (this.input.available() > 0) {
                    int i2 = this.input.read(buf);
                    if (i2 > 0) {
                        this.output.write(buf, 0, i2);
                        this.output.flush();
                        continue;
                    }
                    this.done = true;
                    continue;
                }
                Object i2 = this.lock;
                synchronized (i2) {
                    if (!this.done) {
                        this.lock.wait(100L);
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            this.exception = e;
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.close();
        }
    }

    private void close() {
        block2: {
            try {
                this.output.close();
            }
            catch (IOException e) {
                if (this.exception != null) break block2;
                this.exception = e;
            }
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

