/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.parser.node.StandardParserVisitor;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private String methodName = "";
    private int paramCount = 0;
    private boolean logOnInvalid = true;
    protected Info uberInfo;
    protected boolean strictRef = false;

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(StandardParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        super.init(context, data);
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
        this.methodName = this.getFirstToken().image;
        this.paramCount = this.jjtGetNumChildren() - 1;
        this.strictRef = this.rsvc.getBoolean("runtime.strict_mode.enable", false);
        this.logOnInvalid = this.rsvc.getBoolean("runtime.log.log_invalid_method_calls", true);
        this.cleanupParserAndTokens();
        return data;
    }

    @Override
    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        try {
            Class<?> param;
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            Object[] params = new Object[this.paramCount];
            Class<?>[] paramClasses = this.paramCount > 0 ? new Class[this.paramCount] : EMPTY_CLASS_ARRAY;
            for (int j = 0; j < this.paramCount; ++j) {
                params[j] = this.jjtGetChild(j + 1).value(context);
                if (params[j] == null) continue;
                paramClasses[j] = params[j].getClass();
            }
            VelMethod method = ClassUtils.getMethod(this.methodName, params, paramClasses, o, context, this, this.strictRef);
            if (o != null && method == null && this.logOnInvalid) {
                StringBuilder plist = new StringBuilder();
                for (int i2 = 0; i2 < params.length; ++i2) {
                    param = paramClasses[i2];
                    plist.append(param == null ? "null" : param.getName());
                    if (i2 >= params.length - 1) continue;
                    plist.append(", ");
                }
                this.log.debug("Object '{}' does not contain method {}({}) (or several ambiguous methods) at {}[line {}, column {}]", o.getClass().getName(), this.methodName, plist, this.getTemplateName(), this.getLine(), this.getColumn());
            }
            IntrospectionCacheData prevICD = context.icacheGet(this);
            if (method == null) {
                if (prevICD != null) {
                    context.icachePut(this, null);
                }
                Object i2 = null;
                return i2;
            }
            if (prevICD == null) {
                context.icachePut(this, new IntrospectionCacheData());
            }
            try {
                Object obj = method.invoke(o, params);
                if (obj == null && method.getReturnType() == Void.TYPE) {
                    param = "";
                    return param;
                }
                param = obj;
                return param;
            }
            catch (InvocationTargetException ite) {
                param = this.handleInvocationException(o, context, ite.getTargetException());
                return param;
            }
            catch (IllegalArgumentException t) {
                param = this.handleInvocationException(o, context, t);
                return param;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "ASTMethod.execute() : exception invoking method '" + this.methodName + "' in " + o.getClass();
                this.log.error(msg, e);
                throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
            }
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    private Object handleInvocationException(Object o, InternalContextAdapter context, Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof StopCommand) {
            throw (StopCommand)t;
        }
        if (t instanceof Exception) {
            try {
                return EventHandlerUtil.methodException(this.rsvc, context, o.getClass(), this.methodName, (Exception)t, this.uberInfo);
            }
            catch (Exception e) {
                throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + e.toString(), e, this.rsvc.getLogContext().getStackTrace(), this.methodName, this.getTemplateName(), this.getLine(), this.getColumn());
            }
        }
        throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + t.toString(), t, this.rsvc.getLogContext().getStackTrace(), this.methodName, this.getTemplateName(), this.getLine(), this.getColumn());
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('.').append(this.getMethodName()).append("(...)");
        this.literal = builder.toString();
        return this.literal;
    }

    public static class MethodCacheKey {
        private final String methodName;
        private final Class<?>[] params;
        private boolean classObject;

        public MethodCacheKey(String methodName, Class<?>[] params, boolean classObject) {
            this.methodName = methodName != null ? methodName : "";
            this.params = params != null ? params : EMPTY_CLASS_ARRAY;
            this.classObject = classObject;
        }

        public boolean equals(Object o) {
            if (o instanceof MethodCacheKey) {
                MethodCacheKey other = (MethodCacheKey)o;
                if (this.params.length == other.params.length && this.methodName.equals(other.methodName) && this.classObject == other.classObject) {
                    for (int i2 = 0; i2 < this.params.length; ++i2) {
                        if (!(this.params[i2] == null ? this.params[i2] != other.params[i2] : !this.params[i2].equals(other.params[i2]))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            for (Class<?> param : this.params) {
                if (param == null) continue;
                result = result * 37 + param.hashCode();
            }
            result = result * 37 + this.methodName.hashCode();
            return result;
        }
    }
}

