/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.RuleSetBase;
import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.Property;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.xml.sax.Attributes;

public class XmlFactoryConfigurationRuleSet
extends RuleSetBase {
    protected Class toolboxConfigurationClass = ToolboxConfiguration.class;
    protected Class toolConfigurationClass = ToolConfiguration.class;
    protected Class dataClass = Data.class;
    protected Class propertyClass = Property.class;

    public void setToolboxConfigurationClass(Class clazz) {
        this.toolboxConfigurationClass = clazz;
    }

    public void setToolConfigurationClass(Class clazz) {
        this.toolConfigurationClass = clazz;
    }

    public void setDataClass(Class clazz) {
        this.dataClass = clazz;
    }

    public void setPropertyClass(Class clazz) {
        this.propertyClass = clazz;
    }

    @Override
    public void addRuleInstances(Digester digester) {
        digester.addObjectCreate("tools/property", this.propertyClass);
        digester.addObjectCreate("tools/*/property", this.propertyClass);
        digester.addObjectCreate("tools/data", this.dataClass);
        digester.addObjectCreate("tools/toolbox", this.toolboxConfigurationClass);
        digester.addObjectCreate("tools/toolbox/tool", this.toolConfigurationClass);
        digester.addSetProperties("tools/property");
        digester.addSetProperties("tools/*/property");
        digester.addSetProperties("tools");
        digester.addSetProperties("tools/data");
        digester.addSetProperties("tools/toolbox");
        digester.addSetProperties("tools/toolbox/tool", "class", "classname");
        digester.addRule("tools", new PropertyAttributeRule());
        digester.addRule("tools/toolbox", new PropertyAttributeRule());
        digester.addRule("tools/toolbox/tool", new PropertyAttributeRule());
        digester.addRule("tools/data", new DataValueInBodyRule());
        digester.addRule("tools/*/property", new DataValueInBodyRule());
        digester.addSetNext("tools/property", "addProperty");
        digester.addSetNext("tools/*/property", "addProperty");
        digester.addSetNext("tools/data", "addData");
        digester.addSetNext("tools/toolbox", "addToolbox");
        digester.addSetNext("tools/toolbox/tool", "addTool");
    }

    public static class PropertyAttributeRule
    extends Rule {
        @Override
        public void begin(String namespace, String element, Attributes attributes) throws Exception {
            Configuration config = (Configuration)this.getDigester().peek();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String name = attributes.getLocalName(i2);
                if ("".equals(name)) {
                    name = attributes.getQName(i2);
                }
                if ("class".equals(name)) continue;
                String value = attributes.getValue(i2);
                config.setProperty(name, value);
            }
        }
    }

    public static class DataValueInBodyRule
    extends Rule {
        @Override
        public void body(String namespace, String element, String value) throws Exception {
            Data data = (Data)this.getDigester().peek();
            if (data.getValue() == null) {
                data.setValue(value);
            }
        }
    }
}

