/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;
import org.apache.velocity.util.introspection.TypeConversionHandler;
import org.slf4j.Logger;

public class Introspector
extends IntrospectorBase {
    public Introspector(Logger log) {
        this(log, null);
    }

    public Introspector(Logger log, TypeConversionHandler conversionHandler) {
        super(log, conversionHandler);
    }

    @Override
    public Method getMethod(Class<?> c, String name, Object[] params) throws IllegalArgumentException {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuilder msg = new StringBuilder("Introspection Error: Ambiguous method invocation ").append(name).append("(");
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 > 0) {
                    msg.append(", ");
                }
                if (params[i2] == null) {
                    msg.append("null");
                    continue;
                }
                msg.append(params[i2].getClass().getName());
            }
            msg.append(") for class ").append(c);
            this.log.debug(msg.toString());
            return null;
        }
    }
}

