/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (null != value) {
            return value;
        }
        try {
            Properties properties = this.instantiateProperties(configuration, type, loader);
            int size = configuration.getChildCount();
            for (int i2 = 0; i2 < size; ++i2) {
                PlexusConfiguration element = configuration.getChild(i2);
                if (element.getChildCount() > 0) {
                    Object name = this.fromExpression(element.getChild("name"), evaluator);
                    this.setProperty(properties, name, element.getChild("value"), evaluator);
                    continue;
                }
                this.setProperty(properties, element.getName(), element, evaluator);
            }
            return properties;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Properties instantiateProperties(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (null == implType || Modifier.isAbstract(implType.getModifiers())) {
            return new Properties();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Properties)impl;
    }

    private void setProperty(Properties properties, Object name, PlexusConfiguration valueConfiguration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String key;
        String string = key = null != name ? name.toString() : null;
        if (null == key) {
            throw new ComponentConfigurationException("Missing name in properties");
        }
        Object value = this.fromExpression(valueConfiguration, evaluator);
        properties.setProperty(key, null != value ? value.toString() : "");
    }
}

