/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddExecutorConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import java.security.Permission;

public class AddExecutorConfigMessageTask
extends AbstractAddConfigMessageTask<DynamicConfigAddExecutorConfigCodec.RequestParameters> {
    public AddExecutorConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected DynamicConfigAddExecutorConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddExecutorConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddExecutorConfigCodec.encodeResponse();
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        ExecutorConfig config = new ExecutorConfig(((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).name, ((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).poolSize);
        config.setQueueCapacity(((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).queueCapacity);
        config.setStatisticsEnabled(((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).statisticsEnabled);
        if (((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).isUserCodeNamespaceExists) {
            config.setUserCodeNamespace(((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).userCodeNamespace);
        }
        return config;
    }

    @Override
    public String getMethodName() {
        return "addExecutorConfig";
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        return ((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).userCodeNamespace != null ? new UserCodeNamespacePermission(((DynamicConfigAddExecutorConfigCodec.RequestParameters)this.parameters).userCodeNamespace, "use") : null;
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        ExecutorConfig executorConfig = (ExecutorConfig)config;
        return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getExecutorConfigs(), executorConfig.getName(), executorConfig);
    }
}

