/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.PutAllOperation;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.MultipleEntryOpSteps;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.StaticParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PutAllOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapEntries mapEntries = state.getMapEntries();
            boolean triggerMapLoader = state.isTriggerMapLoader();
            boolean loadOldValue = triggerMapLoader && ((PutAllOperation)state.getOperation()).isHasMapListener();
            ArrayList<Data> keysToLoadOldValue = loadOldValue ? new ArrayList<Data>() : Collections.emptyList();
            Map<Data, Data> batchMap = MapUtil.createHashMap(mapEntries.size());
            List<Map.Entry<Data, Data>> entries = mapEntries.entries();
            for (Map.Entry<Data, Data> entry : entries) {
                if (loadOldValue && recordStore.getRecord(entry.getKey()) == null) {
                    keysToLoadOldValue.add(entry.getKey());
                }
                batchMap.put(entry.getKey(), entry.getValue());
            }
            state.setResult(batchMap);
            state.setKeysToLoad(keysToLoadOldValue);
        }

        @Override
        public Step nextStep(State state) {
            if (CollectionUtil.isNotEmpty(state.getKeysToLoad())) {
                return LOAD_ALL;
            }
            return STORE_ALL;
        }
    }
    ,
    LOAD_ALL{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            MultipleEntryOpSteps.LOAD_ALL.runStep(state);
        }

        @Override
        public Step nextStep(State state) {
            return STORE_ALL;
        }
    }
    ,
    STORE_ALL{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            long expirationTime = recordStore.getExpirySystem().calculateExpirationTime(state.getTtl(), state.getMaxIdle(), state.getNow(), state.getNow());
            Map result = (Map)state.getResult();
            HashMap newResult = new HashMap();
            Iterator iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                Object storedValue = recordStore.getMapDataStore().add((Data)entry.getKey(), entry.getValue(), expirationTime, state.getNow(), null);
                newResult.put(entry.getKey(), storedValue);
            }
            state.setResult(newResult);
        }

        @Override
        public Step nextStep(State state) {
            return PROCESS;
        }
    }
    ,
    PROCESS{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            boolean triggerMapLoader = state.isTriggerMapLoader();
            MapEntries mapEntries = state.getMapEntries();
            List<Map.Entry<Data, Data>> entries = mapEntries.entries();
            HashMap<Data, Data> oldValueByKey = new HashMap<Data, Data>();
            Map result = (Map)state.getResult();
            State perKeyState = new State(state);
            boolean loadOldValue = triggerMapLoader && ((PutAllOperation)state.getOperation()).isHasMapListener();
            List loadedKeyAndOldValueWithExpiryPairs = state.loadedKeyAndOldValueWithExpiryPairs();
            HashMap loadedOldValuesPerKey = new HashMap();
            for (int i = 0; i < loadedKeyAndOldValueWithExpiryPairs.size(); i += 2) {
                Data key = (Data)loadedKeyAndOldValueWithExpiryPairs.get(i);
                BiTuple biTuple = (BiTuple)loadedKeyAndOldValueWithExpiryPairs.get(i + 1);
                loadedOldValuesPerKey.put(key, biTuple.element1);
            }
            for (Map.Entry<Data, Data> entry : entries) {
                Record record;
                Object oldValue = null;
                if (loadOldValue) {
                    oldValue = loadedOldValuesPerKey.get(entry.getKey());
                }
                if (oldValue == null && (record = recordStore.getRecord(entry.getKey())) != null) {
                    oldValue = recordStore.copyToHeapWhenNeeded(record.getValue());
                }
                perKeyState.setKey(entry.getKey()).setOldValue(oldValue).setNewValue(result.get(entry.getKey())).setStaticPutParams(loadOldValue ? StaticParams.PUT_PARAMS : StaticParams.SET_PARAMS);
                PutOpSteps.ON_STORE.runStep(perKeyState);
                if (!loadOldValue || oldValue == null) continue;
                oldValueByKey.put(perKeyState.getKey(), mapServiceContext.toData(perKeyState.getOldValue()));
            }
            state.setResult(oldValueByKey);
        }

        @Override
        public Step nextStep(State state) {
            return AFTER_RUN;
        }
    }
    ,
    AFTER_RUN{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            PutAllOperation operation = (PutAllOperation)state.getOperation();
            List<Map.Entry<Data, Data>> entries = state.getMapEntries().entries();
            for (Map.Entry<Data, Data> entry : entries) {
                if (recordStore.getRecord(entry.getKey()) == null) continue;
                Data dataKey = entry.getKey();
                Data newValue = entry.getValue();
                Data dataValue = operation.getValueOrPostProcessedValue(dataKey, newValue);
                mapServiceContext.interceptAfterPut(mapContainer.getInterceptorRegistry(), dataValue);
                if (operation.isHasMapListener()) {
                    Map oldValueByKey = (Map)state.getResult();
                    Object oldValue = oldValueByKey.get(dataKey);
                    EntryEventType eventType = oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
                    mapEventPublisher.publishEvent(state.getCallerAddress(), state.getOperation().getName(), eventType, dataKey, oldValue, dataValue);
                }
                if (operation.isHasWanReplication()) {
                    operation.publishWanUpdate(dataKey, dataValue);
                }
                if (operation.isHasInvalidation()) {
                    operation.getInvalidationKeys().add(dataKey);
                }
                if (operation.isHasBackups()) {
                    operation.getBackupPairs().add(dataKey);
                    operation.getBackupPairs().add(dataValue);
                }
                operation.evict(dataKey);
            }
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

