/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.messagevortex.MessageVortexLogger;

public class MessageVortexStatus {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static Image image;
    private static TrayIcon trayIcon;

    public static synchronized void displayMessage(final String title, final String message) {
        if (SystemTray.isSupported()) {
            LOGGER.log(Level.INFO, "(" + title + ")" + message);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    trayIcon.displayMessage("MessageVortex" + (String)(title != null ? " " + title : ""), message, TrayIcon.MessageType.INFO);
                }
            });
        }
    }

    static {
        InputStream res = ClassLoader.getSystemResourceAsStream("images/MessageVortexLogo_32.png");
        try {
            image = ImageIO.read(res);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "error while loading try icon", ioe);
        }
        trayIcon = null;
        if (SystemTray.isSupported() && trayIcon == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (UnsupportedLookAndFeelException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            UIManager.put("swing.boldMetal", Boolean.FALSE);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SystemTray tray = SystemTray.getSystemTray();
                    trayIcon = new TrayIcon(image, "MessageVortex");
                    trayIcon.setImageAutoSize(true);
                    trayIcon.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LOGGER.log(Level.INFO, "got event " + String.valueOf(e));
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            LOGGER.log(Level.INFO, "displaying event " + String.valueOf(e));
                            MessageVortexStatus.displayMessage("Action", "Some action performed");
                        }
                    });
                    try {
                        tray.add(trayIcon);
                    }
                    catch (AWTException e) {
                        System.err.println("TrayIcon could not be added.");
                    }
                }
            });
        }
    }
}

