/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.router.operation.BitShifter;
import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public abstract class AbstractRedundancyOperation
extends Operation
implements ASN1Choice,
Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000032L;
    public static final int INPUT_ID = 16000;
    public static final int DATA_STRIPES = 16001;
    public static final int REDUNDANCY = 16002;
    public static final int KEYS = 16003;
    public static final int OUTPUT_ID = 16004;
    public static final int GF_SIZE = 16005;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    int inputId;
    int dataStripes = 1;
    int redundancyStripes = 1;
    final ArrayList<SymmetricKey> stripeKeys = new ArrayList();
    int outputId;
    int gfSize = 4;

    AbstractRedundancyOperation() {
    }

    public AbstractRedundancyOperation(int inputId, int dataStripes, int redundancy, List<SymmetricKey> stripeKeys, int newFirstId, int gfSize) {
        this.inputId = inputId;
        this.setGfSize(gfSize);
        this.setDataStripes(dataStripes);
        this.setRedundancy(redundancy);
        this.setKeys(stripeKeys);
        this.outputId = newFirstId;
    }

    public AbstractRedundancyOperation(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void parse(ASN1Encodable p) throws IOException {
        LOGGER.log(Level.FINER, "Executing parse()");
        int i = 0;
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)p);
        this.inputId = this.parseIntVal(ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++)), 16000, "inputId");
        this.dataStripes = this.parseIntVal(ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++)), 16001, "dataStripes");
        this.redundancyStripes = this.parseIntVal(ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++)), 16002, "redundancy");
        ASN1TaggedObject to = ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++));
        if (to.getTagNo() != 16003) {
            throw new IOException("got unknown tag id (" + to.getTagNo() + ") when expecting keys");
        }
        ASN1Sequence s = ASN1Sequence.getInstance((Object)to.getBaseObject());
        ArrayList<SymmetricKey> arrayList = this.stripeKeys;
        synchronized (arrayList) {
            this.stripeKeys.clear();
            for (ASN1Encodable o : s) {
                this.stripeKeys.add(new SymmetricKey(AbstractRedundancyOperation.toDer((ASN1Object)o.toASN1Primitive())));
            }
        }
        this.outputId = this.parseIntVal(ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++)), 16004, "outputId");
        this.gfSize = this.parseIntVal(ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i++)), 16005, "gfSize");
        LOGGER.log(Level.FINER, "Finished parse()");
    }

    private int parseIntVal(ASN1TaggedObject obj, int id, String description) throws IOException {
        if (obj.getTagNo() != id) {
            throw new IOException("got unknown tag id (" + id + ") when expecting " + description);
        }
        return ASN1Integer.getInstance((Object)obj.getBaseObject()).getValue().intValue();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        LOGGER.log(Level.FINER, "Executing toAsn1Object()");
        ASN1EncodableVector v = new ASN1EncodableVector();
        LOGGER.log(Level.FINER, "  adding inputId");
        v.add((ASN1Encodable)new DERTaggedObject(16000, (ASN1Encodable)new ASN1Integer((long)this.inputId)));
        LOGGER.log(Level.FINER, "  adding dataStripes");
        v.add((ASN1Encodable)new DERTaggedObject(16001, (ASN1Encodable)new ASN1Integer((long)this.dataStripes)));
        LOGGER.log(Level.FINER, "  adding redundancy");
        v.add((ASN1Encodable)new DERTaggedObject(16002, (ASN1Encodable)new ASN1Integer((long)this.redundancyStripes)));
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (SymmetricKey k : this.stripeKeys) {
            v2.add((ASN1Encodable)k.toAsn1Object(dumpType));
        }
        v.add((ASN1Encodable)new DERTaggedObject(16003, (ASN1Encodable)new DERSequence(v2)));
        LOGGER.log(Level.FINER, "  adding outputId");
        v.add((ASN1Encodable)new DERTaggedObject(16004, (ASN1Encodable)new ASN1Integer((long)this.outputId)));
        LOGGER.log(Level.FINER, "  adding gfSize");
        v.add((ASN1Encodable)new DERTaggedObject(16005, (ASN1Encodable)new ASN1Integer((long)this.gfSize)));
        DERSequence seq = new DERSequence(v);
        LOGGER.log(Level.FINER, "done toAsn1Object()");
        return seq;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append("  {\r\n");
        sb.append(prefix).append("  inputId ").append(this.inputId).append(',').append("\r\n");
        sb.append(prefix).append("  dataStripes ").append(this.dataStripes).append(',').append("\r\n");
        sb.append(prefix).append("  redundancy ").append(this.redundancyStripes).append(',').append("\r\n");
        sb.append(prefix).append("  keys {").append("\r\n");
        int i = this.stripeKeys.size();
        for (SymmetricKey sk : this.stripeKeys) {
            sb.append(sk.dumpValueNotation(prefix + "  ", dumpType));
            if (--i > 0) {
                sb.append(',');
            }
            sb.append("\r\n");
        }
        sb.append(prefix).append("  },").append("\r\n");
        sb.append(prefix).append("  outputId ").append(this.outputId).append(',').append("\r\n");
        sb.append(prefix).append("  gfSize ").append(this.gfSize).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public final int setInputId(int id) {
        int old = this.inputId;
        this.inputId = id;
        return old;
    }

    public final int getInputId() {
        return this.inputId;
    }

    public final int setDataStripes(int stripes) {
        if (stripes < 1 || stripes + this.redundancyStripes > BitShifter.lshift(2, this.gfSize, (byte)33)) {
            throw new ArithmeticException("too many stripes to be accommodated in given galois field");
        }
        int old = this.dataStripes;
        this.dataStripes = stripes;
        return old;
    }

    public final int getDataStripes() {
        return this.dataStripes;
    }

    public final int setRedundancy(int stripes) {
        if (stripes < 1) {
            throw new ArithmeticException("too few stripes to be accommodated in current Galois field");
        }
        if (stripes + this.dataStripes > BitShifter.lshift(2, this.gfSize, (byte)33)) {
            throw new ArithmeticException("too many stripes to be accommodated in current galois field");
        }
        int old = this.redundancyStripes;
        this.redundancyStripes = stripes;
        return old;
    }

    public int getRedundancy() {
        return this.redundancyStripes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SymmetricKey[] setKeys(List<SymmetricKey> keys) {
        if (keys == null) {
            keys = new Vector<SymmetricKey>();
        }
        if (this.dataStripes + this.redundancyStripes != keys.size() && keys.size() != 0) {
            throw new ArithmeticException("illegal number of keys");
        }
        SymmetricKey[] old = this.stripeKeys.toArray(new SymmetricKey[0]);
        ArrayList<SymmetricKey> arrayList = this.stripeKeys;
        synchronized (arrayList) {
            this.stripeKeys.clear();
            this.stripeKeys.addAll(keys);
        }
        return old;
    }

    public SymmetricKey[] getKeys() {
        return this.stripeKeys.toArray(new SymmetricKey[0]);
    }

    public final int setGfSize(int omega) {
        if (omega < 2 || omega > 16 || this.redundancyStripes + this.dataStripes > BitShifter.lshift(2, omega, (byte)33)) {
            throw new ArithmeticException("galois field too small for the stripes to be accommodated");
        }
        int old = this.gfSize;
        this.gfSize = omega;
        return old;
    }

    public final int getGfSize() {
        return this.gfSize;
    }

    public int setOutputId(int id) {
        int old = this.outputId;
        this.outputId = id;
        return old;
    }

    public int getOutputId() {
        return this.outputId;
    }
}

