/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender;

import java.io.IOException;
import net.messagevortex.AbstractDaemon;
import net.messagevortex.accounting.HeaderVerifier;
import net.messagevortex.asn1.BlendingSpec;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.blender.BlendingReceiver;
import net.messagevortex.blender.BlendingSender;
import net.messagevortex.router.IncomingMessageRouterListener;
import net.messagevortex.transport.TransportReceiver;
import net.messagevortex.transport.TransportSender;

public abstract class Blender
extends AbstractDaemon
implements TransportReceiver,
BlendingSender {
    private IncomingMessageRouterListener listener = null;
    private HeaderVerifier headerVerifier = null;
    private BlendingReceiver blendingReceiver = null;
    private TransportSender transportSender = null;

    public Blender(BlendingReceiver receiver, HeaderVerifier verifier) {
        this.setBlenderReceiver(receiver);
        this.setVerifier(verifier);
    }

    public IncomingMessageRouterListener setIncomingMessageListener(IncomingMessageRouterListener listener) {
        IncomingMessageRouterListener old = this.listener;
        this.listener = listener;
        return old;
    }

    public final HeaderVerifier getVerifier() {
        return this.headerVerifier;
    }

    public final HeaderVerifier setVerifier(HeaderVerifier verifier) {
        HeaderVerifier ret = this.getVerifier();
        this.headerVerifier = verifier;
        return ret;
    }

    public final BlendingReceiver setBlenderReceiver(BlendingReceiver receiver) {
        BlendingReceiver ret = this.blendingReceiver;
        this.blendingReceiver = receiver;
        return ret;
    }

    public final TransportSender setTransportSender(TransportSender sender) {
        TransportSender ret = this.transportSender;
        this.transportSender = sender;
        return ret;
    }

    public final TransportSender getTransportSender() {
        return this.transportSender;
    }

    @Override
    public abstract boolean blendMessage(BlendingSpec var1, VortexMessage var2) throws IOException;

    public abstract String getBlendingAddress();

    public abstract byte[] blendMessageToBytes(BlendingSpec var1, VortexMessage var2);

    public abstract VortexMessage unblendMessage(byte[] var1);
}

