/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import picocli.CommandLine;

@CommandLine.Command(description={"list available ciphers"}, name="list", aliases={"lst"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerCipherList
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--type", "-t"}, description={"type of information (ASYM, SYM, MODE, PAD)"})
    CipherType[] types = new CipherType[]{CipherType.ASYM, CipherType.SYM, CipherType.MODE, CipherType.PAD};

    @Override
    public Integer call() throws Exception {
        for (CipherType c : this.types) {
            switch (c) {
                case ASYM: {
                    int i;
                    System.out.println("Asymmetric cpiher types:");
                    for (Enum enum_ : Algorithm.getAlgorithms(AlgorithmType.ASYMMETRIC)) {
                        System.out.print("  " + String.valueOf(enum_));
                        System.out.print(" (modes: ");
                        i = 0;
                        for (Mode mode : Mode.getModes((Algorithm)enum_)) {
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            ++i;
                            System.out.print(mode.toString());
                        }
                        System.out.print("; paddings: ");
                        i = 0;
                        for (Enum enum_2 : Padding.getAlgorithms(((Algorithm)enum_).getAlgorithmType())) {
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            ++i;
                            System.out.print(enum_2);
                        }
                        System.out.println(')');
                    }
                    break;
                }
                case SYM: {
                    int i;
                    System.out.println("Symmetric cpiher types:");
                    for (Enum enum_ : Algorithm.getAlgorithms(AlgorithmType.SYMMETRIC)) {
                        System.out.print("  " + String.valueOf(enum_));
                        System.out.print(" (modes: ");
                        i = 0;
                        for (Mode mode : Mode.getModes((Algorithm)enum_)) {
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            ++i;
                            System.out.print(mode.toString());
                        }
                        System.out.print("; paddings: ");
                        i = 0;
                        for (Enum enum_3 : Padding.getAlgorithms(((Algorithm)enum_).getAlgorithmType())) {
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            ++i;
                            System.out.print(enum_3);
                        }
                        System.out.println(')');
                    }
                    break;
                }
                case MODE: {
                    System.out.println("Cipher mode:");
                    for (Enum enum_ : Mode.values()) {
                        System.out.println("  " + enum_.name());
                    }
                    break;
                }
                case PAD: {
                    System.out.println("Padding types:");
                    for (Enum enum_ : Padding.values()) {
                        System.out.println("  " + enum_.name());
                    }
                    break;
                }
                default: {
                    System.err.println("ERROR: Unknown type specified");
                    throw new IOException("Unknown type specified");
                }
            }
            System.out.println();
            System.out.flush();
        }
        return 0;
    }

    static enum CipherType {
        ASYM,
        SYM,
        MODE,
        PAD;

    }
}

