/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.messagevortex.router.Edge;
import net.messagevortex.router.GraphSet;
import net.messagevortex.router.TooltipContainer;
import net.messagevortex.router.TooltipExtentBox;

public class JGraph
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1213422324789789L;
    private static final int X_OFFSET = 20;
    private static final int Y_OFFSET = 10;
    private static final int ROUTE_BORDER = 10;
    private static final int BOX_HEIGHT = 15;
    private static final int BOX_WIDTH = 20;
    private int route = 0;
    private final GraphSet graph;
    private final TooltipContainer ttContainer = new TooltipContainer();

    public JGraph(GraphSet gs) {
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.graph = gs;
        this.update();
        ToolTipManager.sharedInstance().setInitialDelay(1);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
    }

    private void update() {
        GraphSet[] routes = this.graph.getRoutes();
        Dimension d = new Dimension(this.graph.getAnonymitySetSize() * 21 + 40, 40 + routes.length * 4);
        this.setMinimumSize(d);
    }

    private void drawTopLabels(Graphics g) {
        double horizontalSpace = (0.0 + (double)this.getWidth() - 40.0 - 20.0) / (double)(this.graph.getAnonymitySetSize() - 1);
        for (int i = 0; i < this.graph.getAnonymitySetSize(); ++i) {
            int x = (int)(20.0 + (double)i * horizontalSpace);
            if (this.graph.getAnonymity(i) == this.graph.getSource()) {
                g.setColor(Color.GREEN);
                g.fillRect(x, 10, 20, 15);
                this.ttContainer.addTooltip(new TooltipExtentBox(new Rectangle2D.Float(x, 10.0f, 20.0f, 15.0f)), "Sender");
            } else if (this.graph.getAnonymity(i) == this.graph.getTarget()) {
                g.setColor(Color.RED);
                g.fillRect(x, 10, 20, 15);
                this.ttContainer.addTooltip(new TooltipExtentBox(new Rectangle2D.Float(x, 10.0f, 20.0f, 15.0f)), "Recipient");
            } else {
                g.setColor(Color.BLACK);
                g.drawRect(x, 10, 20, 15);
                this.ttContainer.addTooltip(new TooltipExtentBox(new Rectangle2D.Float(x, 10.0f, 20.0f, 15.0f)), "Anonymity node");
            }
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            int hgt = metrics.getHeight();
            int adv = metrics.stringWidth("" + i);
            g.setColor(Color.BLACK);
            g.drawString("" + i, x + 10 - adv / 2, 17 + (hgt + 2) / 2 - 2);
            Graphics2D g3 = (Graphics2D)g.create();
            g3.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f));
            g3.drawLine(x + 10, 25, x + 10, this.getHeight() - 10 - 20);
            g3.dispose();
        }
    }

    private void drawArrows(Graphics g) {
        GraphSet[] routes = this.graph.getRoutes();
        double horizontalSpace = (0.0 + (double)this.getWidth() - 40.0 - 20.0) / (double)(this.graph.getAnonymitySetSize() - 1);
        double verticalSpace = (0.0 + (double)this.getHeight() - 20.0 - 30.0 - 10.0) / (double)this.graph.size();
        Graphics2D g2 = (Graphics2D)g.create();
        Stroke s = g2.getStroke();
        BasicStroke s2 = new BasicStroke(3.0f);
        int lastY = 0;
        if (this.route >= 0) {
            System.out.println("## displaying route " + this.route + " (" + routes[this.route].size() + ")");
        } else {
            System.out.println("## no route set");
        }
        for (int i = 0; i < this.graph.size(); ++i) {
            Edge gr = this.graph.get(i);
            int x1 = (int)(30.0 + (double)this.graph.getAnonymityIndex(gr.getFrom()) * horizontalSpace);
            int x2 = (int)(30.0 + (double)this.graph.getAnonymityIndex(gr.getTo()) * horizontalSpace);
            int y = (int)(40.0 + (double)i * verticalSpace);
            if (this.route >= 0 && routes[this.route].contains(gr)) {
                System.out.println("##   route " + this.route + " contains " + i + " (" + String.valueOf(this.route < 0 ? "none" : Integer.valueOf(routes[this.route].size())) + "/" + gr.getStartTime() + ")");
                g2.setColor(Color.GREEN);
                g2.setStroke(s2);
                if (lastY > 0) {
                    g2.drawLine(x1, lastY, x1, y);
                }
                lastY = y;
            } else {
                g2.setStroke(s);
                g2.setColor(Color.BLACK);
            }
            g2.drawLine(x1, y, x2, y);
            int xh = (int)((double)(x2 - x1) / (double)Math.abs(x2 - x1) * verticalSpace);
            g2.drawLine(x2, y, x2 - xh, y - xh / 4);
            g2.drawLine(x2, y, x2 - xh, y + xh / 4);
            g2.dispose();
        }
    }

    private void drawRouteButtons(Graphics g) {
        GraphSet[] routes = this.graph.getRoutes();
        double horizontalSpace = (double)(this.getWidth() - 40) / (double)(routes.length * 2 - 1);
        for (int i = 0; i < routes.length; ++i) {
            int x1 = (int)(((double)this.getWidth() - (double)(routes.length * 2 - 1) * horizontalSpace) / 2.0 + (double)i * horizontalSpace * 2.0);
            int y = this.getHeight() - 10 - 10;
            if (this.route == i) {
                g.setColor(Color.BLUE);
                g.fillRect(x1, y, (int)horizontalSpace, 10);
            }
            g.setColor(Color.BLACK);
            g.drawRect(x1, y, (int)horizontalSpace, 10);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawTopLabels(g);
        this.drawArrows(g);
        this.drawRouteButtons(g);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String t = this.ttContainer.getTooltipText(new Point(event.getX(), event.getY()));
        if (t == null) {
            t = super.getToolTipText(event);
        }
        return t;
    }

    public int setRoute(int r) {
        int s = this.graph.getRoutes().length;
        if (r < 0 || s <= r) {
            r = -1;
        }
        int old = this.route;
        this.route = r;
        if (old != r) {
            this.repaint();
        }
        return old;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e != null) {
            int oldPos;
            GraphSet[] routes = this.graph.getRoutes();
            double horizontalSpace = (double)(this.getWidth() - 40) / (double)(routes.length * 2 - 1);
            int offset = (int)((double)this.getWidth() - (double)(routes.length * 2 - 1) * horizontalSpace) / 2;
            int tmp = e.getX() - offset;
            int pos = (int)Math.min(Math.floor((0.0 + (double)tmp) / (horizontalSpace * 2.0)), (double)routes.length);
            int y = this.getHeight() - 10 - 10;
            tmp -= (int)((0.0 + (double)pos) * 2.0 * horizontalSpace);
            if (e.getY() <= y + 10 && e.getY() >= y && (double)tmp < horizontalSpace && (oldPos = this.setRoute(Math.min(routes.length, pos))) == pos) {
                this.setRoute(-1);
            }
        }
    }

    public void createAndShowUserInterface(int x, int y) {
        System.out.println("Created GUI on event dispatching thread? " + SwingUtilities.isEventDispatchThread());
        JFrame f = new JFrame("Edge Demo");
        f.add(this);
        f.setDefaultCloseOperation(3);
        f.setSize(x, y);
        f.pack();
        f.setVisible(true);
    }

    public void createAndShowUserInterface() {
        this.createAndShowUserInterface(250, 100);
    }

    public BufferedImage getScreenShot(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        this.setSize(width, height);
        this.paintComponent(image.getGraphics());
        return image;
    }

    public void saveScreenshot(String filename, int width, int height) throws IOException {
        BufferedImage image = this.getScreenShot(width, height);
        try (OutputStream os = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "jpg", os);
        }
    }
}

